/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.pqc.crypto.saber;

import java.security.SecureRandom;
import sqsaml.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import sqsaml.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import sqsaml.org.bouncycastle.crypto.KeyGenerationParameters;
import sqsaml.org.bouncycastle.pqc.crypto.saber.SABEREngine;
import sqsaml.org.bouncycastle.pqc.crypto.saber.SABERKeyGenerationParameters;
import sqsaml.org.bouncycastle.pqc.crypto.saber.SABERPrivateKeyParameters;
import sqsaml.org.bouncycastle.pqc.crypto.saber.SABERPublicKeyParameters;

public class SABERKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SABERKeyGenerationParameters saberParams;
    private int l;
    private SecureRandom random;

    private void initialize(KeyGenerationParameters keyGenerationParameters) {
        this.saberParams = (SABERKeyGenerationParameters)keyGenerationParameters;
        this.random = keyGenerationParameters.getRandom();
        this.l = this.saberParams.getParameters().getL();
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        SABEREngine sABEREngine = this.saberParams.getParameters().getEngine();
        byte[] byArray = new byte[sABEREngine.getPrivateKeySize()];
        byte[] byArray2 = new byte[sABEREngine.getPublicKeySize()];
        sABEREngine.crypto_kem_keypair(byArray2, byArray, this.random);
        SABERPublicKeyParameters sABERPublicKeyParameters = new SABERPublicKeyParameters(this.saberParams.getParameters(), byArray2);
        SABERPrivateKeyParameters sABERPrivateKeyParameters = new SABERPrivateKeyParameters(this.saberParams.getParameters(), byArray);
        return new AsymmetricCipherKeyPair(sABERPublicKeyParameters, sABERPrivateKeyParameters);
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.initialize(keyGenerationParameters);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

