/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.operator.bc;

import java.io.IOException;
import sqsaml.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import sqsaml.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import sqsaml.org.bouncycastle.crypto.ExtendedDigest;
import sqsaml.org.bouncycastle.crypto.Signer;
import sqsaml.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import sqsaml.org.bouncycastle.crypto.signers.RSADigestSigner;
import sqsaml.org.bouncycastle.crypto.util.PublicKeyFactory;
import sqsaml.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import sqsaml.org.bouncycastle.operator.OperatorCreationException;
import sqsaml.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;

public class BcRSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcRSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new RSADigestSigner(extendedDigest);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

