/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.jce.provider;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import sqsaml.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import sqsaml.org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import sqsaml.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import sqsaml.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import sqsaml.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import sqsaml.org.bouncycastle.crypto.CryptoServiceConstraintsException;
import sqsaml.org.bouncycastle.crypto.CryptoServiceProperties;
import sqsaml.org.bouncycastle.crypto.CryptoServicePurpose;
import sqsaml.org.bouncycastle.crypto.CryptoServicesRegistrar;
import sqsaml.org.bouncycastle.internal.asn1.isara.IsaraObjectIdentifiers;
import sqsaml.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import sqsaml.org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import sqsaml.org.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import sqsaml.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import sqsaml.org.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import sqsaml.org.bouncycastle.jce.provider.BouncyCastleProviderConfiguration;
import sqsaml.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import sqsaml.org.bouncycastle.pqc.jcajce.provider.bike.BIKEKeyFactorySpi;
import sqsaml.org.bouncycastle.pqc.jcajce.provider.cmce.CMCEKeyFactorySpi;
import sqsaml.org.bouncycastle.pqc.jcajce.provider.dilithium.DilithiumKeyFactorySpi;
import sqsaml.org.bouncycastle.pqc.jcajce.provider.falcon.FalconKeyFactorySpi;
import sqsaml.org.bouncycastle.pqc.jcajce.provider.hqc.HQCKeyFactorySpi;
import sqsaml.org.bouncycastle.pqc.jcajce.provider.kyber.KyberKeyFactorySpi;
import sqsaml.org.bouncycastle.pqc.jcajce.provider.lms.LMSKeyFactorySpi;
import sqsaml.org.bouncycastle.pqc.jcajce.provider.newhope.NHKeyFactorySpi;
import sqsaml.org.bouncycastle.pqc.jcajce.provider.ntru.NTRUKeyFactorySpi;
import sqsaml.org.bouncycastle.pqc.jcajce.provider.picnic.PicnicKeyFactorySpi;
import sqsaml.org.bouncycastle.pqc.jcajce.provider.sphincs.Sphincs256KeyFactorySpi;
import sqsaml.org.bouncycastle.pqc.jcajce.provider.sphincsplus.SPHINCSPlusKeyFactorySpi;
import sqsaml.org.bouncycastle.pqc.jcajce.provider.xmss.XMSSKeyFactorySpi;
import sqsaml.org.bouncycastle.pqc.jcajce.provider.xmss.XMSSMTKeyFactorySpi;
import sqsaml.org.bouncycastle.util.Strings;

public final class BouncyCastleProvider
extends Provider
implements ConfigurableProvider {
    private static final Logger LOG = Logger.getLogger(BouncyCastleProvider.class.getName());
    private static String info = "BouncyCastle Security Provider v1.78.1";
    public static final String PROVIDER_NAME = "BC";
    public static final ProviderConfiguration CONFIGURATION = new BouncyCastleProviderConfiguration();
    private static final Map keyInfoConverters = new HashMap();
    private static final Class revChkClass = ClassUtil.loadClass(BouncyCastleProvider.class, "java.security.cert.PKIXRevocationChecker");
    private static final String SYMMETRIC_PACKAGE = "sqsaml.org.bouncycastle.jcajce.provider.symmetric.";
    private static final String[] SYMMETRIC_GENERIC = new String[]{"PBEPBKDF1", "PBEPBKDF2", "PBEPKCS12", "TLSKDF", "SCRYPT"};
    private static final String[] SYMMETRIC_MACS = new String[]{"SipHash", "SipHash128", "Poly1305"};
    private static final CryptoServiceProperties[] SYMMETRIC_CIPHERS = new CryptoServiceProperties[]{BouncyCastleProvider.service((String)"AES", (int)256), BouncyCastleProvider.service((String)"ARC4", (int)20), BouncyCastleProvider.service((String)"ARIA", (int)256), BouncyCastleProvider.service((String)"Blowfish", (int)128), BouncyCastleProvider.service((String)"Camellia", (int)256), BouncyCastleProvider.service((String)"CAST5", (int)128), BouncyCastleProvider.service((String)"CAST6", (int)256), BouncyCastleProvider.service((String)"ChaCha", (int)128), BouncyCastleProvider.service((String)"DES", (int)56), BouncyCastleProvider.service((String)"DESede", (int)112), BouncyCastleProvider.service((String)"GOST28147", (int)128), BouncyCastleProvider.service((String)"Grainv1", (int)128), BouncyCastleProvider.service((String)"Grain128", (int)128), BouncyCastleProvider.service((String)"HC128", (int)128), BouncyCastleProvider.service((String)"HC256", (int)256), BouncyCastleProvider.service((String)"IDEA", (int)128), BouncyCastleProvider.service((String)"Noekeon", (int)128), BouncyCastleProvider.service((String)"RC2", (int)128), BouncyCastleProvider.service((String)"RC5", (int)128), BouncyCastleProvider.service((String)"RC6", (int)256), BouncyCastleProvider.service((String)"Rijndael", (int)256), BouncyCastleProvider.service((String)"Salsa20", (int)128), BouncyCastleProvider.service((String)"SEED", (int)128), BouncyCastleProvider.service((String)"Serpent", (int)256), BouncyCastleProvider.service((String)"Shacal2", (int)128), BouncyCastleProvider.service((String)"Skipjack", (int)80), BouncyCastleProvider.service((String)"SM4", (int)128), BouncyCastleProvider.service((String)"TEA", (int)128), BouncyCastleProvider.service((String)"Twofish", (int)256), BouncyCastleProvider.service((String)"Threefish", (int)128), BouncyCastleProvider.service((String)"VMPC", (int)128), BouncyCastleProvider.service((String)"VMPCKSA3", (int)128), BouncyCastleProvider.service((String)"XTEA", (int)128), BouncyCastleProvider.service((String)"XSalsa20", (int)128), BouncyCastleProvider.service((String)"OpenSSLPBKDF", (int)128), BouncyCastleProvider.service((String)"DSTU7624", (int)256), BouncyCastleProvider.service((String)"GOST3412_2015", (int)256), BouncyCastleProvider.service((String)"Zuc", (int)128)};
    private static final String ASYMMETRIC_PACKAGE = "sqsaml.org.bouncycastle.jcajce.provider.asymmetric.";
    private static final String[] ASYMMETRIC_GENERIC = new String[]{"X509", "IES", "COMPOSITE", "EXTERNAL", "CompositeSignatures"};
    private static final String[] ASYMMETRIC_CIPHERS = new String[]{"DSA", "DH", "EC", "RSA", "GOST", "ECGOST", "ElGamal", "DSTU4145", "GM", "EdEC", "LMS", "SPHINCSPlus", "Dilithium", "Falcon", "NTRU"};
    private static final String DIGEST_PACKAGE = "sqsaml.org.bouncycastle.jcajce.provider.digest.";
    private static final String[] DIGESTS = new String[]{"GOST3411", "Keccak", "MD2", "MD4", "MD5", "SHA1", "RIPEMD128", "RIPEMD160", "RIPEMD256", "RIPEMD320", "SHA224", "SHA256", "SHA384", "SHA512", "SHA3", "Skein", "SM3", "Tiger", "Whirlpool", "Blake2b", "Blake2s", "DSTU7564", "Haraka", "Blake3"};
    private static final String KEYSTORE_PACKAGE = "sqsaml.org.bouncycastle.jcajce.provider.keystore.";
    private static final String[] KEYSTORES = new String[]{"BC", "BCFKS", "PKCS12"};
    private static final String SECURE_RANDOM_PACKAGE = "sqsaml.org.bouncycastle.jcajce.provider.drbg.";
    private static final String[] SECURE_RANDOMS = new String[]{"DRBG"};
    private Map<String, Provider.Service> serviceMap = new ConcurrentHashMap();

    public BouncyCastleProvider() {
        super(PROVIDER_NAME, 1.7801, info);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                BouncyCastleProvider.this.setup();
                return null;
            }
        });
    }

    private void setup() {
        this.loadAlgorithms(DIGEST_PACKAGE, DIGESTS);
        this.loadAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC_GENERIC);
        this.loadAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC_MACS);
        this.loadAlgorithms(SYMMETRIC_PACKAGE, (CryptoServiceProperties[])SYMMETRIC_CIPHERS);
        this.loadAlgorithms(ASYMMETRIC_PACKAGE, ASYMMETRIC_GENERIC);
        this.loadAlgorithms(ASYMMETRIC_PACKAGE, ASYMMETRIC_CIPHERS);
        this.loadAlgorithms(KEYSTORE_PACKAGE, KEYSTORES);
        this.loadAlgorithms(SECURE_RANDOM_PACKAGE, SECURE_RANDOMS);
        this.loadPQCKeys();
        this.put("X509Store.CERTIFICATE/COLLECTION", "sqsaml.org.bouncycastle.jce.provider.X509StoreCertCollection");
        this.put("X509Store.ATTRIBUTECERTIFICATE/COLLECTION", "sqsaml.org.bouncycastle.jce.provider.X509StoreAttrCertCollection");
        this.put("X509Store.CRL/COLLECTION", "sqsaml.org.bouncycastle.jce.provider.X509StoreCRLCollection");
        this.put("X509Store.CERTIFICATEPAIR/COLLECTION", "sqsaml.org.bouncycastle.jce.provider.X509StoreCertPairCollection");
        this.put("X509Store.CERTIFICATE/LDAP", "sqsaml.org.bouncycastle.jce.provider.X509StoreLDAPCerts");
        this.put("X509Store.CRL/LDAP", "sqsaml.org.bouncycastle.jce.provider.X509StoreLDAPCRLs");
        this.put("X509Store.ATTRIBUTECERTIFICATE/LDAP", "sqsaml.org.bouncycastle.jce.provider.X509StoreLDAPAttrCerts");
        this.put("X509Store.CERTIFICATEPAIR/LDAP", "sqsaml.org.bouncycastle.jce.provider.X509StoreLDAPCertPairs");
        this.put("X509StreamParser.CERTIFICATE", "sqsaml.org.bouncycastle.jce.provider.X509CertParser");
        this.put("X509StreamParser.ATTRIBUTECERTIFICATE", "sqsaml.org.bouncycastle.jce.provider.X509AttrCertParser");
        this.put("X509StreamParser.CRL", "sqsaml.org.bouncycastle.jce.provider.X509CRLParser");
        this.put("X509StreamParser.CERTIFICATEPAIR", "sqsaml.org.bouncycastle.jce.provider.X509CertPairParser");
        this.put("Cipher.BROKENPBEWITHMD5ANDDES", "sqsaml.org.bouncycastle.jce.provider.BrokenJCEBlockCipher$BrokePBEWithMD5AndDES");
        this.put("Cipher.BROKENPBEWITHSHA1ANDDES", "sqsaml.org.bouncycastle.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHA1AndDES");
        this.put("Cipher.OLDPBEWITHSHAANDTWOFISH-CBC", "sqsaml.org.bouncycastle.jce.provider.BrokenJCEBlockCipher$OldPBEWithSHAAndTwofish");
        if (revChkClass != null) {
            this.put("CertPathValidator.RFC3281", "sqsaml.org.bouncycastle.jce.provider.PKIXAttrCertPathValidatorSpi");
            this.put("CertPathBuilder.RFC3281", "sqsaml.org.bouncycastle.jce.provider.PKIXAttrCertPathBuilderSpi");
            this.put("CertPathValidator.RFC3280", "sqsaml.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi_8");
            this.put("CertPathBuilder.RFC3280", "sqsaml.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi_8");
            this.put("CertPathValidator.PKIX", "sqsaml.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi_8");
            this.put("CertPathBuilder.PKIX", "sqsaml.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi_8");
        } else {
            this.put("CertPathValidator.RFC3281", "sqsaml.org.bouncycastle.jce.provider.PKIXAttrCertPathValidatorSpi");
            this.put("CertPathBuilder.RFC3281", "sqsaml.org.bouncycastle.jce.provider.PKIXAttrCertPathBuilderSpi");
            this.put("CertPathValidator.RFC3280", "sqsaml.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
            this.put("CertPathBuilder.RFC3280", "sqsaml.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
            this.put("CertPathValidator.PKIX", "sqsaml.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
            this.put("CertPathBuilder.PKIX", "sqsaml.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
        }
        this.put("CertStore.Collection", "sqsaml.org.bouncycastle.jce.provider.CertStoreCollectionSpi");
        this.put("CertStore.LDAP", "sqsaml.org.bouncycastle.jce.provider.X509LDAPCertStoreSpi");
        this.put("CertStore.Multi", "sqsaml.org.bouncycastle.jce.provider.MultiCertStoreSpi");
        this.put("Alg.Alias.CertStore.X509LDAP", "LDAP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Provider.Service getService(final String string, final String string2) {
        String string3 = Strings.toUpperCase(string2);
        final String string4 = string + "." + string3;
        Provider.Service service = (Provider.Service)this.serviceMap.get(string4);
        if (service == null) {
            BouncyCastleProvider bouncyCastleProvider = this;
            synchronized (bouncyCastleProvider) {
                service = !this.serviceMap.containsKey(string4) ? AccessController.doPrivileged(new PrivilegedAction<Provider.Service>(){

                    @Override
                    public Provider.Service run() {
                        Provider.Service service = BouncyCastleProvider.access$101((BouncyCastleProvider)BouncyCastleProvider.this, (String)string, (String)string2);
                        if (service == null) {
                            return null;
                        }
                        BouncyCastleProvider.access$200((BouncyCastleProvider)BouncyCastleProvider.this).put(string4, service);
                        BouncyCastleProvider.access$301((BouncyCastleProvider)BouncyCastleProvider.this, (Object)(service.getType() + "." + service.getAlgorithm()));
                        BouncyCastleProvider.access$401((BouncyCastleProvider)BouncyCastleProvider.this, (Provider.Service)service);
                        return service;
                    }
                }) : (Provider.Service)this.serviceMap.get(string4);
            }
        }
        return service;
    }

    private void loadAlgorithms(String string, String[] stringArray) {
        for (int i = 0; i != stringArray.length; ++i) {
            this.loadServiceClass(string, stringArray[i]);
        }
    }

    private void loadAlgorithms(String string, CryptoServiceProperties[] cryptoServicePropertiesArray) {
        for (int i = 0; i != cryptoServicePropertiesArray.length; ++i) {
            CryptoServiceProperties cryptoServiceProperties = cryptoServicePropertiesArray[i];
            try {
                CryptoServicesRegistrar.checkConstraints((CryptoServiceProperties)cryptoServiceProperties);
                this.loadServiceClass(string, cryptoServiceProperties.getServiceName());
                continue;
            }
            catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("service for " + cryptoServiceProperties.getServiceName() + " ignored due to constraints");
            }
        }
    }

    private void loadServiceClass(String string, String string2) {
        Class clazz = ClassUtil.loadClass(BouncyCastleProvider.class, string + string2 + "$Mappings");
        if (clazz != null) {
            try {
                ((AlgorithmProvider)clazz.newInstance()).configure(this);
            }
            catch (Exception exception) {
                throw new InternalError("cannot create instance of " + string + string2 + "$Mappings : " + exception);
            }
        }
    }

    private void loadPQCKeys() {
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128s_r3, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128f_r3, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128s_r3, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128f_r3, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_128s_r3, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_128f_r3, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192s_r3, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192f_r3, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192s_r3, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192f_r3, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_192s_r3, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_192f_r3, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256s_r3, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256f_r3, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256s_r3, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256f_r3, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_256s_r3, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_256f_r3, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128s_r3_simple, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128f_r3_simple, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128s_r3_simple, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128f_r3_simple, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_128s_r3_simple, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_128f_r3_simple, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192s_r3_simple, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192f_r3_simple, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192s_r3_simple, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192f_r3_simple, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_192s_r3_simple, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_192f_r3_simple, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256s_r3_simple, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256f_r3_simple, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256s_r3_simple, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256f_r3_simple, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_256s_r3_simple, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_256f_r3_simple, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128s, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192s, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256s, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(new ASN1ObjectIdentifier("1.3.9999.6.4.10"), new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128f, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192f, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256f, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.sphincs256, new Sphincs256KeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.newHope, new NHKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.xmss, new XMSSKeyFactorySpi());
        this.addKeyInfoConverter(IsaraObjectIdentifiers.id_alg_xmss, new XMSSKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.xmss_mt, new XMSSMTKeyFactorySpi());
        this.addKeyInfoConverter(IsaraObjectIdentifiers.id_alg_xmssmt, new XMSSMTKeyFactorySpi());
        this.addKeyInfoConverter(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig, new LMSKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.picnic_key, new PicnicKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.falcon_512, new FalconKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.falcon_1024, new FalconKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium2, new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium3, new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium5, new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium2_aes, new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium3_aes, new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium5_aes, new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber512, new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber768, new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber1024, new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece348864_r3, new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece460896_r3, new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece6688128_r3, new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece6960119_r3, new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece8192128_r3, new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.bike128, new BIKEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.bike192, new BIKEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.bike256, new BIKEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.hqc128, new HQCKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.hqc192, new HQCKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.hqc256, new HQCKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber1024, new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber512_aes, new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber768_aes, new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber1024_aes, new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.ntruhps2048509, new NTRUKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.ntruhps2048677, new NTRUKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.ntruhps4096821, new NTRUKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.ntruhrss701, new NTRUKeyFactorySpi());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameter(String string, Object object) {
        ProviderConfiguration providerConfiguration = CONFIGURATION;
        synchronized (providerConfiguration) {
            ((BouncyCastleProviderConfiguration)CONFIGURATION).setParameter(string, object);
        }
    }

    @Override
    public boolean hasAlgorithm(String string, String string2) {
        return this.containsKey(string + "." + string2) || this.containsKey("Alg.Alias." + string + "." + string2);
    }

    @Override
    public void addAlgorithm(String string, String string2) {
        if (this.containsKey(string)) {
            throw new IllegalStateException("duplicate provider key (" + string + ") found");
        }
        this.put(string, string2);
    }

    public void addAlgorithm(String string, String string2, Map<String, String> map) {
        this.addAlgorithm(string, string2);
        this.addAttributes(string, map);
    }

    @Override
    public void addAlgorithm(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2) {
        this.addAlgorithm(string + "." + aSN1ObjectIdentifier, string2);
        this.addAlgorithm(string + ".OID." + aSN1ObjectIdentifier, string2);
    }

    public void addAlgorithm(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2, Map<String, String> map) {
        this.addAlgorithm(string, aSN1ObjectIdentifier, string2);
        this.addAttributes(string + "." + aSN1ObjectIdentifier, map);
        this.addAttributes(string + ".OID." + aSN1ObjectIdentifier, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter) {
        Map map = keyInfoConverters;
        synchronized (map) {
            keyInfoConverters.put(aSN1ObjectIdentifier, asymmetricKeyInfoConverter);
        }
    }

    public AsymmetricKeyInfoConverter getKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (AsymmetricKeyInfoConverter)keyInfoConverters.get(aSN1ObjectIdentifier);
    }

    @Override
    public void addAttributes(String string, Map<String, String> map) {
        this.put(string + " ImplementedIn", "Software");
        for (String string2 : map.keySet()) {
            String string3 = string + " " + string2;
            if (this.containsKey(string3)) {
                throw new IllegalStateException("duplicate provider attribute key (" + string3 + ") found");
            }
            this.put(string3, map.get(string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AsymmetricKeyInfoConverter getAsymmetricKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Map map = keyInfoConverters;
        synchronized (map) {
            return (AsymmetricKeyInfoConverter)keyInfoConverters.get(aSN1ObjectIdentifier);
        }
    }

    public static PublicKey getPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        if (subjectPublicKeyInfo.getAlgorithm().getAlgorithm().on(BCObjectIdentifiers.picnic_key)) {
            return new PicnicKeyFactorySpi().generatePublic(subjectPublicKeyInfo);
        }
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = BouncyCastleProvider.getAsymmetricKeyInfoConverter(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePublic(subjectPublicKeyInfo);
    }

    public static PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = BouncyCastleProvider.getAsymmetricKeyInfoConverter(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePrivate(privateKeyInfo);
    }

    private static CryptoServiceProperties service(String string, int n) {
        return new JcaCryptoService(string, n);
    }

    static /* synthetic */ void access$000(BouncyCastleProvider bouncyCastleProvider) {
        bouncyCastleProvider.setup();
    }

    static /* synthetic */ Provider.Service access$101(BouncyCastleProvider bouncyCastleProvider, String string, String string2) {
        return super.getService(string, string2);
    }

    static /* synthetic */ Map access$200(BouncyCastleProvider bouncyCastleProvider) {
        return bouncyCastleProvider.serviceMap;
    }

    static /* synthetic */ Object access$301(BouncyCastleProvider bouncyCastleProvider, Object object) {
        return super.remove(object);
    }

    static /* synthetic */ void access$401(BouncyCastleProvider bouncyCastleProvider, Provider.Service service) {
        super.putService(service);
    }

    private static class JcaCryptoService
    implements CryptoServiceProperties {
        private final String name;
        private final int bitsOfSecurity;

        JcaCryptoService(String string, int n) {
            this.name = string;
            this.bitsOfSecurity = n;
        }

        @Override
        public int bitsOfSecurity() {
            return this.bitsOfSecurity;
        }

        @Override
        public String getServiceName() {
            return this.name;
        }

        @Override
        public CryptoServicePurpose getPurpose() {
            return CryptoServicePurpose.ANY;
        }

        @Override
        public Object getParams() {
            return null;
        }
    }
}

