/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.asn1;

import java.io.IOException;
import sqsaml.org.bouncycastle.asn1.ASN1Encodable;
import sqsaml.org.bouncycastle.asn1.ASN1OutputStream;
import sqsaml.org.bouncycastle.asn1.ASN1Primitive;
import sqsaml.org.bouncycastle.asn1.ASN1Sequence;
import sqsaml.org.bouncycastle.asn1.ASN1TaggedObject;
import sqsaml.org.bouncycastle.asn1.DLSequence;

public class DLTaggedObject
extends ASN1TaggedObject {
    public DLTaggedObject(int n, ASN1Encodable aSN1Encodable) {
        super(true, n, aSN1Encodable);
    }

    public DLTaggedObject(int n, int n2, ASN1Encodable aSN1Encodable) {
        super(true, n, n2, aSN1Encodable);
    }

    public DLTaggedObject(boolean bl, int n, ASN1Encodable aSN1Encodable) {
        super(bl, n, aSN1Encodable);
    }

    public DLTaggedObject(boolean bl, int n, int n2, ASN1Encodable aSN1Encodable) {
        super(bl, n, n2, aSN1Encodable);
    }

    DLTaggedObject(int n, int n2, int n3, ASN1Encodable aSN1Encodable) {
        super(n, n2, n3, aSN1Encodable);
    }

    boolean encodeConstructed() {
        return this.isExplicit() || this.obj.toASN1Primitive().toDLObject().encodeConstructed();
    }

    int encodedLength(boolean bl) throws IOException {
        ASN1Primitive aSN1Primitive = this.obj.toASN1Primitive().toDLObject();
        boolean bl2 = this.isExplicit();
        int n = aSN1Primitive.encodedLength(bl2);
        if (bl2) {
            n += ASN1OutputStream.getLengthOfDL((int)n);
        }
        return n += bl ? ASN1OutputStream.getLengthOfIdentifier((int)this.tagNo) : 0;
    }

    @Override
    void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        ASN1Primitive aSN1Primitive = this.obj.toASN1Primitive().toDLObject();
        boolean bl2 = this.isExplicit();
        if (bl) {
            int n = this.tagClass;
            if (bl2 || aSN1Primitive.encodeConstructed()) {
                n |= 0x20;
            }
            aSN1OutputStream.writeIdentifier(true, n, this.tagNo);
        }
        if (bl2) {
            aSN1OutputStream.writeDL(aSN1Primitive.encodedLength(true));
        }
        aSN1Primitive.encode(aSN1OutputStream.getDLSubStream(), bl2);
    }

    ASN1Sequence rebuildConstructed(ASN1Primitive aSN1Primitive) {
        return new DLSequence(aSN1Primitive);
    }

    ASN1TaggedObject replaceTag(int n, int n2) {
        return new DLTaggedObject(this.explicitness, n, n2, this.obj);
    }

    @Override
    ASN1Primitive toDLObject() {
        return this;
    }
}

