/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.xml.security.keys.content.x509;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import sqsaml.org.apache.xml.security.exceptions.XMLSecurityException;
import sqsaml.org.apache.xml.security.keys.content.x509.XMLX509DataContent;
import sqsaml.org.apache.xml.security.utils.SignatureElementProxy;
import sqsaml.org.apache.xml.security.utils.XMLUtils;

public class XMLX509SKI
extends SignatureElementProxy
implements XMLX509DataContent {
    private static final System.Logger LOG = System.getLogger(XMLX509SKI.class.getName());
    public static final String SKI_OID = "2.5.29.14";

    public XMLX509SKI(Document doc, byte[] skiBytes) {
        super(doc);
        this.addBase64Text(skiBytes);
    }

    public XMLX509SKI(Document doc, X509Certificate x509certificate) throws XMLSecurityException {
        super(doc);
        this.addBase64Text(XMLX509SKI.getSKIBytesFromCert(x509certificate));
    }

    public XMLX509SKI(Element element, String baseURI) throws XMLSecurityException {
        super(element, baseURI);
    }

    public byte[] getSKIBytes() throws XMLSecurityException {
        return this.getBytesFromTextChild();
    }

    public static byte[] getSKIBytesFromCert(X509Certificate cert) throws XMLSecurityException {
        if (cert.getVersion() < 3) {
            Object[] exArgs = new Object[]{cert.getVersion()};
            throw new XMLSecurityException("certificate.noSki.lowVersion", exArgs);
        }
        byte[] extensionValue = cert.getExtensionValue(SKI_OID);
        if (extensionValue == null) {
            throw new XMLSecurityException("certificate.noSki.null");
        }
        byte[] skidValue = new byte[extensionValue.length - 4];
        System.arraycopy(extensionValue, 4, skidValue, 0, skidValue.length);
        if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
            LOG.log(System.Logger.Level.DEBUG, "Base64 of SKI is " + XMLUtils.encodeToString(skidValue));
        }
        return skidValue;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XMLX509SKI)) {
            return false;
        }
        XMLX509SKI other = (XMLX509SKI)obj;
        try {
            return Arrays.equals(other.getSKIBytes(), this.getSKIBytes());
        }
        catch (XMLSecurityException ex) {
            return false;
        }
    }

    public int hashCode() {
        int result = 17;
        try {
            byte[] bytes;
            for (byte element : bytes = this.getSKIBytes()) {
                result = 31 * result + element;
            }
        }
        catch (XMLSecurityException e) {
            LOG.log(System.Logger.Level.DEBUG, e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public String getBaseLocalName() {
        return "X509SKI";
    }
}

