/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.commons.httpclient.contrib.ssl;

import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import sqsaml.org.apache.commons.ssl.HttpSecureProtocol;
import sqsaml.org.apache.commons.ssl.KeyMaterial;
import sqsaml.org.apache.commons.ssl.TrustMaterial;

public class AuthSSLProtocolSocketFactory
extends HttpSecureProtocol {
    public AuthSSLProtocolSocketFactory(URL keystoreUrl, String keystorePassword, URL truststoreUrl, String truststorePassword) throws GeneralSecurityException, IOException {
        if (keystoreUrl != null) {
            char[] ksPass = null;
            if (keystorePassword != null) {
                ksPass = keystorePassword.toCharArray();
            }
            KeyMaterial km = new KeyMaterial(keystoreUrl, ksPass);
            super.setKeyMaterial(km);
        }
        if (truststoreUrl != null) {
            TrustMaterial tm;
            char[] tsPass = null;
            if (truststorePassword != null) {
                tsPass = truststorePassword.toCharArray();
            }
            try {
                tm = new KeyMaterial(truststoreUrl, tsPass);
            }
            catch (KeyStoreException kse) {
                tm = new TrustMaterial(truststoreUrl, tsPass);
            }
            super.setTrustMaterial(tm);
        }
    }
}

