/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.bcel.classfile;

import java.util.Objects;
import java.util.Stack;
import java.util.stream.Stream;
import sqsaml.org.apache.bcel.classfile.AnnotationDefault;
import sqsaml.org.apache.bcel.classfile.AnnotationEntry;
import sqsaml.org.apache.bcel.classfile.Annotations;
import sqsaml.org.apache.bcel.classfile.BootstrapMethods;
import sqsaml.org.apache.bcel.classfile.Code;
import sqsaml.org.apache.bcel.classfile.CodeException;
import sqsaml.org.apache.bcel.classfile.ConstantClass;
import sqsaml.org.apache.bcel.classfile.ConstantDouble;
import sqsaml.org.apache.bcel.classfile.ConstantDynamic;
import sqsaml.org.apache.bcel.classfile.ConstantFieldref;
import sqsaml.org.apache.bcel.classfile.ConstantFloat;
import sqsaml.org.apache.bcel.classfile.ConstantInteger;
import sqsaml.org.apache.bcel.classfile.ConstantInterfaceMethodref;
import sqsaml.org.apache.bcel.classfile.ConstantInvokeDynamic;
import sqsaml.org.apache.bcel.classfile.ConstantLong;
import sqsaml.org.apache.bcel.classfile.ConstantMethodHandle;
import sqsaml.org.apache.bcel.classfile.ConstantMethodType;
import sqsaml.org.apache.bcel.classfile.ConstantMethodref;
import sqsaml.org.apache.bcel.classfile.ConstantModule;
import sqsaml.org.apache.bcel.classfile.ConstantNameAndType;
import sqsaml.org.apache.bcel.classfile.ConstantPackage;
import sqsaml.org.apache.bcel.classfile.ConstantPool;
import sqsaml.org.apache.bcel.classfile.ConstantString;
import sqsaml.org.apache.bcel.classfile.ConstantUtf8;
import sqsaml.org.apache.bcel.classfile.ConstantValue;
import sqsaml.org.apache.bcel.classfile.Deprecated;
import sqsaml.org.apache.bcel.classfile.EnclosingMethod;
import sqsaml.org.apache.bcel.classfile.ExceptionTable;
import sqsaml.org.apache.bcel.classfile.Field;
import sqsaml.org.apache.bcel.classfile.InnerClass;
import sqsaml.org.apache.bcel.classfile.InnerClasses;
import sqsaml.org.apache.bcel.classfile.JavaClass;
import sqsaml.org.apache.bcel.classfile.LineNumber;
import sqsaml.org.apache.bcel.classfile.LineNumberTable;
import sqsaml.org.apache.bcel.classfile.LocalVariable;
import sqsaml.org.apache.bcel.classfile.LocalVariableTable;
import sqsaml.org.apache.bcel.classfile.LocalVariableTypeTable;
import sqsaml.org.apache.bcel.classfile.Method;
import sqsaml.org.apache.bcel.classfile.MethodParameter;
import sqsaml.org.apache.bcel.classfile.MethodParameters;
import sqsaml.org.apache.bcel.classfile.Module;
import sqsaml.org.apache.bcel.classfile.ModuleExports;
import sqsaml.org.apache.bcel.classfile.ModuleMainClass;
import sqsaml.org.apache.bcel.classfile.ModuleOpens;
import sqsaml.org.apache.bcel.classfile.ModulePackages;
import sqsaml.org.apache.bcel.classfile.ModuleProvides;
import sqsaml.org.apache.bcel.classfile.ModuleRequires;
import sqsaml.org.apache.bcel.classfile.NestHost;
import sqsaml.org.apache.bcel.classfile.NestMembers;
import sqsaml.org.apache.bcel.classfile.Node;
import sqsaml.org.apache.bcel.classfile.ParameterAnnotationEntry;
import sqsaml.org.apache.bcel.classfile.ParameterAnnotations;
import sqsaml.org.apache.bcel.classfile.Signature;
import sqsaml.org.apache.bcel.classfile.SourceFile;
import sqsaml.org.apache.bcel.classfile.StackMap;
import sqsaml.org.apache.bcel.classfile.StackMapEntry;
import sqsaml.org.apache.bcel.classfile.Synthetic;
import sqsaml.org.apache.bcel.classfile.Unknown;
import sqsaml.org.apache.bcel.classfile.Visitor;

public class DescendingVisitor
implements Visitor {
    private final JavaClass clazz;
    private final Visitor visitor;
    private final Stack<Object> stack = new Stack();

    public DescendingVisitor(JavaClass clazz, Visitor visitor) {
        this.clazz = clazz;
        this.visitor = visitor;
    }

    private <E extends Node> void accept(E[] node) {
        Stream.of(node).forEach(e -> e.accept(this));
    }

    public Object current() {
        return this.stack.peek();
    }

    public Object predecessor() {
        return this.predecessor(0);
    }

    public Object predecessor(int level) {
        int size = this.stack.size();
        if (size < 2 || level < 0) {
            return null;
        }
        return this.stack.elementAt(size - (level + 2));
    }

    public void visit() {
        this.clazz.accept(this);
    }

    @Override
    public void visitAnnotation(Annotations annotation) {
        this.stack.push(annotation);
        annotation.accept(this.visitor);
        this.accept(annotation.getAnnotationEntries());
        this.stack.pop();
    }

    @Override
    public void visitAnnotationDefault(AnnotationDefault obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitAnnotationEntry(AnnotationEntry annotationEntry) {
        this.stack.push(annotationEntry);
        annotationEntry.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitBootstrapMethods(BootstrapMethods bm) {
        this.stack.push(bm);
        bm.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitCode(Code code) {
        this.stack.push(code);
        code.accept(this.visitor);
        this.accept(code.getExceptionTable());
        this.accept(code.getAttributes());
        this.stack.pop();
    }

    @Override
    public void visitCodeException(CodeException ce) {
        this.stack.push(ce);
        ce.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantClass(ConstantClass constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantDouble(ConstantDouble constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantDynamic(ConstantDynamic obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantFieldref(ConstantFieldref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantFloat(ConstantFloat constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInteger(ConstantInteger constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInvokeDynamic(ConstantInvokeDynamic constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantLong(ConstantLong constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodHandle(ConstantMethodHandle obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodref(ConstantMethodref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodType(ConstantMethodType obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantModule(ConstantModule obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantNameAndType(ConstantNameAndType constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantPackage(ConstantPackage obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantPool(ConstantPool cp) {
        this.stack.push(cp);
        cp.accept(this.visitor);
        Stream.of(cp.getConstantPool()).filter(Objects::nonNull).forEach(e -> e.accept(this));
        this.stack.pop();
    }

    @Override
    public void visitConstantString(ConstantString constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantUtf8(ConstantUtf8 constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantValue(ConstantValue cv) {
        this.stack.push(cv);
        cv.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitDeprecated(Deprecated attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitEnclosingMethod(EnclosingMethod obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitExceptionTable(ExceptionTable table) {
        this.stack.push(table);
        table.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitField(Field field) {
        this.stack.push(field);
        field.accept(this.visitor);
        this.accept(field.getAttributes());
        this.stack.pop();
    }

    @Override
    public void visitInnerClass(InnerClass inner) {
        this.stack.push(inner);
        inner.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitInnerClasses(InnerClasses ic) {
        this.stack.push(ic);
        ic.accept(this.visitor);
        this.accept(ic.getInnerClasses());
        this.stack.pop();
    }

    @Override
    public void visitJavaClass(JavaClass clazz) {
        this.stack.push(clazz);
        clazz.accept(this.visitor);
        this.accept(clazz.getFields());
        this.accept(clazz.getMethods());
        this.accept(clazz.getAttributes());
        clazz.getConstantPool().accept(this);
        this.stack.pop();
    }

    @Override
    public void visitLineNumber(LineNumber number) {
        this.stack.push(number);
        number.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLineNumberTable(LineNumberTable table) {
        this.stack.push(table);
        table.accept(this.visitor);
        this.accept(table.getLineNumberTable());
        this.stack.pop();
    }

    @Override
    public void visitLocalVariable(LocalVariable var) {
        this.stack.push(var);
        var.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariableTable(LocalVariableTable table) {
        this.stack.push(table);
        table.accept(this.visitor);
        this.accept(table.getLocalVariableTable());
        this.stack.pop();
    }

    @Override
    public void visitLocalVariableTypeTable(LocalVariableTypeTable obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitMethod(Method method) {
        this.stack.push(method);
        method.accept(this.visitor);
        this.accept(method.getAttributes());
        this.stack.pop();
    }

    @Override
    public void visitMethodParameter(MethodParameter obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitMethodParameters(MethodParameters obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        Stream.of(obj.getParameters()).forEach(e -> e.accept(this));
        this.stack.pop();
    }

    @Override
    public void visitModule(Module obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.accept(obj.getRequiresTable());
        this.accept(obj.getExportsTable());
        this.accept(obj.getOpensTable());
        this.accept(obj.getProvidesTable());
        this.stack.pop();
    }

    @Override
    public void visitModuleExports(ModuleExports obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitModuleMainClass(ModuleMainClass obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitModuleOpens(ModuleOpens obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitModulePackages(ModulePackages obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitModuleProvides(ModuleProvides obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitModuleRequires(ModuleRequires obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitNestHost(NestHost obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitNestMembers(NestMembers obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitParameterAnnotation(ParameterAnnotations obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitParameterAnnotationEntry(ParameterAnnotationEntry obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSignature(Signature attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSourceFile(SourceFile attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitStackMap(StackMap table) {
        this.stack.push(table);
        table.accept(this.visitor);
        this.accept(table.getStackMap());
        this.stack.pop();
    }

    @Override
    public void visitStackMapEntry(StackMapEntry var) {
        this.stack.push(var);
        var.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSynthetic(Synthetic attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitUnknown(Unknown attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }
}

