/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.nu.xom;

import java.io.IOException;
import java.io.Writer;
import sqsaml.nu.xom.TextWriter;
import sqsaml.nu.xom.XMLException;

final class UnicodeWriter
extends TextWriter {
    UnicodeWriter(Writer writer, String string) {
        super(writer, string);
    }

    @Override
    boolean needsEscaping(char c) {
        return false;
    }

    @Override
    void writeMarkup(String string) throws IOException {
        int n;
        if (this.normalize) {
            string = this.normalize(string);
        }
        if ((n = UnicodeWriter.getUnicodeLengthForMarkup(string)) >= 0) {
            this.out.write(string);
            if (n > 0) {
                this.column += n;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
            }
        } else {
            int n2 = string.length();
            for (int i = 0; i < n2; ++i) {
                this.writeMarkup(string.charAt(i));
            }
        }
    }

    @Override
    void writeName(String string) throws IOException {
        if (this.normalize) {
            string = this.normalize(string);
        }
        int n = UnicodeWriter.getUnicodeLengthForName(string);
        this.out.write(string);
        this.column += n;
        this.lastCharacterWasSpace = false;
        this.skipFollowingLinefeed = false;
        this.justBroke = false;
    }

    private static int getUnicodeLengthForMarkup(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c <= ' ') {
                return -1;
            }
            if (c >= '\ud800' && c <= '\udbff') continue;
            ++n;
        }
        return n;
    }

    private static int getUnicodeLengthForName(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= '\ud800' && c <= '\udbff') continue;
            ++n;
        }
        return n;
    }

    @Override
    void writeAttributeValue(String string) throws IOException {
        int n;
        if (this.normalize) {
            string = this.normalize(string);
        }
        if ((n = UnicodeWriter.getUnicodeLengthForAttributeValue(string)) >= 0) {
            this.out.write(string);
            if (n > 0) {
                this.column += n;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
            }
        } else {
            int n2 = string.length();
            for (int i = 0; i < n2; ++i) {
                this.writeAttributeValue(string.charAt(i));
            }
        }
    }

    private static int getUnicodeLengthForAttributeValue(String string) {
        int n = 0;
        int n2 = string.length();
        block38: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': {
                    return -1;
                }
                case '\n': {
                    return -1;
                }
                case '\u000b': 
                case '\f': {
                    throw new XMLException("Bad character snuck into document");
                }
                case '\r': {
                    return -1;
                }
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    throw new XMLException("Bad character snuck into document");
                }
                case ' ': {
                    return -1;
                }
                case '!': {
                    ++n;
                    continue block38;
                }
                case '\"': {
                    return -1;
                }
                case '#': {
                    ++n;
                    continue block38;
                }
                case '$': {
                    ++n;
                    continue block38;
                }
                case '%': {
                    ++n;
                    continue block38;
                }
                case '&': {
                    return -1;
                }
                case '\'': {
                    ++n;
                    continue block38;
                }
                case '(': {
                    ++n;
                    continue block38;
                }
                case ')': {
                    ++n;
                    continue block38;
                }
                case '*': {
                    ++n;
                    continue block38;
                }
                case '+': {
                    ++n;
                    continue block38;
                }
                case ',': {
                    ++n;
                    continue block38;
                }
                case '-': {
                    ++n;
                    continue block38;
                }
                case '.': {
                    ++n;
                    continue block38;
                }
                case '/': {
                    ++n;
                    continue block38;
                }
                case '0': {
                    ++n;
                    continue block38;
                }
                case '1': {
                    ++n;
                    continue block38;
                }
                case '2': {
                    ++n;
                    continue block38;
                }
                case '3': {
                    ++n;
                    continue block38;
                }
                case '4': {
                    ++n;
                    continue block38;
                }
                case '5': {
                    ++n;
                    continue block38;
                }
                case '6': {
                    ++n;
                    continue block38;
                }
                case '7': {
                    ++n;
                    continue block38;
                }
                case '8': {
                    ++n;
                    continue block38;
                }
                case '9': {
                    ++n;
                    continue block38;
                }
                case ':': {
                    ++n;
                    continue block38;
                }
                case ';': {
                    ++n;
                    continue block38;
                }
                case '<': {
                    return -1;
                }
                case '=': {
                    ++n;
                    continue block38;
                }
                case '>': {
                    return -1;
                }
                default: {
                    if (c >= '\ud800' && c <= '\udbff') continue block38;
                    ++n;
                }
            }
        }
        return n;
    }

    @Override
    void writePCDATA(String string) throws IOException {
        int n;
        if (this.normalize) {
            string = this.normalize(string);
        }
        if ((n = UnicodeWriter.getUnicodeLengthForPCDATA(string)) >= 0) {
            this.out.write(string);
            if (n > 0) {
                this.column += n;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
            }
        } else {
            int n2 = string.length();
            for (int i = 0; i < n2; ++i) {
                this.writePCDATA(string.charAt(i));
            }
        }
    }

    private static int getUnicodeLengthForPCDATA(String string) {
        int n = 0;
        int n2 = string.length();
        block38: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': {
                    return -1;
                }
                case '\n': {
                    return -1;
                }
                case '\u000b': 
                case '\f': {
                    throw new XMLException("Bad character snuck into document");
                }
                case '\r': {
                    return -1;
                }
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    throw new XMLException("Bad character snuck into document");
                }
                case ' ': {
                    return -1;
                }
                case '!': {
                    ++n;
                    continue block38;
                }
                case '\"': {
                    ++n;
                    continue block38;
                }
                case '#': {
                    ++n;
                    continue block38;
                }
                case '$': {
                    ++n;
                    continue block38;
                }
                case '%': {
                    ++n;
                    continue block38;
                }
                case '&': {
                    return -1;
                }
                case '\'': {
                    ++n;
                    continue block38;
                }
                case '(': {
                    ++n;
                    continue block38;
                }
                case ')': {
                    ++n;
                    continue block38;
                }
                case '*': {
                    ++n;
                    continue block38;
                }
                case '+': {
                    ++n;
                    continue block38;
                }
                case ',': {
                    ++n;
                    continue block38;
                }
                case '-': {
                    ++n;
                    continue block38;
                }
                case '.': {
                    ++n;
                    continue block38;
                }
                case '/': {
                    ++n;
                    continue block38;
                }
                case '0': {
                    ++n;
                    continue block38;
                }
                case '1': {
                    ++n;
                    continue block38;
                }
                case '2': {
                    ++n;
                    continue block38;
                }
                case '3': {
                    ++n;
                    continue block38;
                }
                case '4': {
                    ++n;
                    continue block38;
                }
                case '5': {
                    ++n;
                    continue block38;
                }
                case '6': {
                    ++n;
                    continue block38;
                }
                case '7': {
                    ++n;
                    continue block38;
                }
                case '8': {
                    ++n;
                    continue block38;
                }
                case '9': {
                    ++n;
                    continue block38;
                }
                case ':': {
                    ++n;
                    continue block38;
                }
                case ';': {
                    ++n;
                    continue block38;
                }
                case '<': {
                    return -1;
                }
                case '=': {
                    ++n;
                    continue block38;
                }
                case '>': {
                    return -1;
                }
                default: {
                    if (c >= '\ud800' && c <= '\udbff') continue block38;
                    ++n;
                }
            }
        }
        return n;
    }
}

