/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.nu.xom;

import java.io.UnsupportedEncodingException;
import sqsaml.nu.xom.CDATASection;
import sqsaml.nu.xom.Node;
import sqsaml.nu.xom.Verifier;

public class Text
extends Node {
    private byte[] data;

    public Text(String string) {
        this._setValue(string);
    }

    public Text(Text text) {
        this.data = text.data;
    }

    private Text() {
    }

    static Text build(String string) {
        Text text = new Text();
        try {
            text.data = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Bad VM! Does not support UTF-8");
        }
        return text;
    }

    public void setValue(String string) {
        this._setValue(string);
    }

    private void _setValue(String string) {
        if (string == null) {
            string = "";
        } else {
            Verifier.checkPCDATA(string);
        }
        try {
            this.data = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Bad VM! Does not support UTF-8");
        }
    }

    @Override
    public final String getValue() {
        try {
            return new String(this.data, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Bad VM! Does not support UTF-8");
        }
    }

    @Override
    public final Node getChild(int n) {
        throw new IndexOutOfBoundsException("LeafNodes do not have children");
    }

    @Override
    public final int getChildCount() {
        return 0;
    }

    @Override
    public Text copy() {
        if (this.isCDATASection()) {
            return new CDATASection(this);
        }
        return new Text(this);
    }

    @Override
    public final String toXML() {
        return this.escapeText();
    }

    String escapeText() {
        String string = this.getValue();
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 12);
        block52: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\r': {
                    stringBuilder.append("&#x0D;");
                    continue block52;
                }
                case '\u000e': {
                    continue block52;
                }
                case '\u000f': {
                    continue block52;
                }
                case '\u0010': {
                    continue block52;
                }
                case '\u0011': {
                    continue block52;
                }
                case '\u0012': {
                    continue block52;
                }
                case '\u0013': {
                    continue block52;
                }
                case '\u0014': {
                    continue block52;
                }
                case '\u0015': {
                    continue block52;
                }
                case '\u0016': {
                    continue block52;
                }
                case '\u0017': {
                    continue block52;
                }
                case '\u0018': {
                    continue block52;
                }
                case '\u0019': {
                    continue block52;
                }
                case '\u001a': {
                    continue block52;
                }
                case '\u001b': {
                    continue block52;
                }
                case '\u001c': {
                    continue block52;
                }
                case '\u001d': {
                    continue block52;
                }
                case '\u001e': {
                    continue block52;
                }
                case '\u001f': {
                    continue block52;
                }
                case ' ': {
                    stringBuilder.append(' ');
                    continue block52;
                }
                case '!': {
                    stringBuilder.append('!');
                    continue block52;
                }
                case '\"': {
                    stringBuilder.append('\"');
                    continue block52;
                }
                case '#': {
                    stringBuilder.append('#');
                    continue block52;
                }
                case '$': {
                    stringBuilder.append('$');
                    continue block52;
                }
                case '%': {
                    stringBuilder.append('%');
                    continue block52;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block52;
                }
                case '\'': {
                    stringBuilder.append('\'');
                    continue block52;
                }
                case '(': {
                    stringBuilder.append('(');
                    continue block52;
                }
                case ')': {
                    stringBuilder.append(')');
                    continue block52;
                }
                case '*': {
                    stringBuilder.append('*');
                    continue block52;
                }
                case '+': {
                    stringBuilder.append('+');
                    continue block52;
                }
                case ',': {
                    stringBuilder.append(',');
                    continue block52;
                }
                case '-': {
                    stringBuilder.append('-');
                    continue block52;
                }
                case '.': {
                    stringBuilder.append('.');
                    continue block52;
                }
                case '/': {
                    stringBuilder.append('/');
                    continue block52;
                }
                case '0': {
                    stringBuilder.append('0');
                    continue block52;
                }
                case '1': {
                    stringBuilder.append('1');
                    continue block52;
                }
                case '2': {
                    stringBuilder.append('2');
                    continue block52;
                }
                case '3': {
                    stringBuilder.append('3');
                    continue block52;
                }
                case '4': {
                    stringBuilder.append('4');
                    continue block52;
                }
                case '5': {
                    stringBuilder.append('5');
                    continue block52;
                }
                case '6': {
                    stringBuilder.append('6');
                    continue block52;
                }
                case '7': {
                    stringBuilder.append('7');
                    continue block52;
                }
                case '8': {
                    stringBuilder.append('8');
                    continue block52;
                }
                case '9': {
                    stringBuilder.append('9');
                    continue block52;
                }
                case ':': {
                    stringBuilder.append(':');
                    continue block52;
                }
                case ';': {
                    stringBuilder.append(';');
                    continue block52;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block52;
                }
                case '=': {
                    stringBuilder.append('=');
                    continue block52;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block52;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    @Override
    boolean isText() {
        return true;
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": " + Text.escapeLineBreaksAndTruncate(this.getValue()) + "]";
    }

    static String escapeLineBreaksAndTruncate(String string) {
        boolean bl;
        int n = string.length();
        boolean bl2 = bl = n > 40;
        if (n > 40) {
            n = 35;
            string = string.substring(0, 35);
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block5;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block5;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block5;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        if (bl) {
            stringBuilder.append("...");
        }
        return stringBuilder.toString();
    }

    boolean isCDATASection() {
        return false;
    }

    boolean isEmpty() {
        return this.data.length == 0;
    }
}

