/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.nu.xom;

import sqsaml.nu.xom.Element;
import sqsaml.nu.xom.IllegalDataException;
import sqsaml.nu.xom.IllegalNameException;
import sqsaml.nu.xom.NamespaceConflictException;
import sqsaml.nu.xom.Node;
import sqsaml.nu.xom.ParentNode;
import sqsaml.nu.xom.Text;
import sqsaml.nu.xom.Verifier;

public class Attribute
extends Node {
    private String localName;
    private String prefix;
    private String URI;
    private String value = "";
    private Type type;

    public Attribute(String string, String string2) {
        this(string, "", string2, Type.UNDECLARED);
    }

    public Attribute(String string, String string2, Type type) {
        this(string, "", string2, type);
    }

    public Attribute(String string, String string2, String string3) {
        this(string, string2, string3, Type.UNDECLARED);
    }

    public Attribute(String string, String string2, String string3, Type type) {
        this.prefix = "";
        String string4 = string;
        int n = string.indexOf(58);
        if (n > 0) {
            this.prefix = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        try {
            this._setLocalName(string4);
        }
        catch (IllegalNameException illegalNameException) {
            illegalNameException.setData(string);
            throw illegalNameException;
        }
        this._setNamespace(this.prefix, string2);
        this._setValue(string3);
        if (this.isXMLID()) {
            this._setType(Type.ID);
        } else {
            this._setType(type);
        }
    }

    public Attribute(Attribute attribute) {
        this.localName = attribute.localName;
        this.prefix = attribute.prefix;
        this.URI = attribute.URI;
        this.value = attribute.value;
        this.type = attribute.type;
    }

    private Attribute() {
    }

    static Attribute build(String string, String string2, String string3, Type type, String string4) {
        Attribute attribute = new Attribute();
        String string5 = "";
        int n = string.indexOf(58);
        if (n >= 0) {
            string5 = string.substring(0, n);
            if ("xml:id".equals(string)) {
                type = Type.ID;
                string3 = Attribute.normalize(string3);
            }
        }
        attribute.localName = string4;
        attribute.prefix = string5;
        attribute.type = type;
        attribute.URI = string2;
        attribute.value = string3;
        return attribute;
    }

    private static String normalize(String string) {
        int n;
        int n2;
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && string.charAt(n2) == ' '; ++n2) {
        }
        string = string.substring(n2);
        for (n = string.length() - 1; n > 0 && string.charAt(n) == ' '; --n) {
        }
        string = string.substring(0, n + 1);
        n3 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n3);
        boolean bl = false;
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (bl) continue;
                stringBuilder.append(' ');
                bl = true;
                continue;
            }
            stringBuilder.append(c);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public final Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new NullPointerException("Null attribute type");
        }
        if (this.isXMLID() && !Type.ID.equals(type)) {
            throw new IllegalDataException("Can't change type of xml:id attribute to " + type);
        }
        this._setType(type);
    }

    private boolean isXMLID() {
        return "xml".equals(this.prefix) && "id".equals(this.localName);
    }

    private void _setType(Type type) {
        this.type = type;
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this._setValue(string);
    }

    private void _setValue(String string) {
        Verifier.checkPCDATA(string);
        if (this.isXMLID()) {
            string = Attribute.normalize(string);
        }
        this.value = string;
    }

    public final String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String string) {
        if ("id".equals(string) && "http://www.w3.org/XML/1998/namespace".equals(this.URI)) {
            Verifier.checkNCName(this.value);
        }
        this._setLocalName(string);
        if (this.isXMLID()) {
            this.setType(Type.ID);
        }
    }

    private void _setLocalName(String string) {
        Verifier.checkNCName(string);
        if (string.equals("xmlns")) {
            throw new IllegalNameException("The Attribute class is not used for namespace declaration attributes.");
        }
        this.localName = string;
    }

    public final String getQualifiedName() {
        if (this.prefix.length() == 0) {
            return this.localName;
        }
        return this.prefix + ":" + this.localName;
    }

    public final String getNamespaceURI() {
        return this.URI;
    }

    public final String getNamespacePrefix() {
        return this.prefix;
    }

    public void setNamespace(String string, String string2) {
        this._setNamespace(string, string2);
        if (this.isXMLID()) {
            this.setType(Type.ID);
        }
    }

    private void _setNamespace(String string, String string2) {
        Element element;
        String string3;
        if (string2 == null) {
            string2 = "";
        }
        if (string == null) {
            string = "";
        }
        if (string.equals("xmlns")) {
            throw new IllegalNameException("Attribute objects are not used to represent  namespace declarations");
        }
        if (string.equals("xml") && !string2.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new NamespaceConflictException("Wrong namespace URI for xml prefix: " + string2);
        }
        if (string2.equals("http://www.w3.org/XML/1998/namespace") && !string.equals("xml")) {
            throw new NamespaceConflictException("Wrong prefix for the XML namespace: " + string);
        }
        if (string.length() == 0) {
            if (string2.length() == 0) {
                this.prefix = "";
                this.URI = "";
                return;
            }
            throw new NamespaceConflictException("Unprefixed attribute " + this.localName + " cannot be in default namespace " + string2);
        }
        if (string2.length() == 0) {
            throw new NamespaceConflictException("Attribute prefixes must be declared.");
        }
        ParentNode parentNode = this.getParent();
        if (parentNode != null && (string3 = (element = (Element)parentNode).getLocalNamespaceURI(string)) != null && !string3.equals(string2)) {
            throw new NamespaceConflictException("New prefix " + string + "conflicts with existing namespace declaration");
        }
        Verifier.checkAbsoluteURIReference(string2);
        Verifier.checkNCName(string);
        this.URI = string2;
        this.prefix = string;
    }

    @Override
    public final Node getChild(int n) {
        throw new IndexOutOfBoundsException("Attributes do not have children");
    }

    @Override
    public final int getChildCount() {
        return 0;
    }

    @Override
    public Attribute copy() {
        return new Attribute(this);
    }

    @Override
    public final String toXML() {
        return this.getQualifiedName() + "=\"" + Attribute.escapeText(this.value) + "\"";
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": " + this.getQualifiedName() + "=\"" + Text.escapeLineBreaksAndTruncate(this.getValue()) + "\"]";
    }

    private static String escapeText(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 12);
        block56: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': {
                    stringBuilder.append("&#x09;");
                    continue block56;
                }
                case '\n': {
                    stringBuilder.append("&#x0A;");
                    continue block56;
                }
                case '\u000b': {
                    continue block56;
                }
                case '\f': {
                    continue block56;
                }
                case '\r': {
                    stringBuilder.append("&#x0D;");
                    continue block56;
                }
                case '\u000e': {
                    continue block56;
                }
                case '\u000f': {
                    continue block56;
                }
                case '\u0010': {
                    continue block56;
                }
                case '\u0011': {
                    continue block56;
                }
                case '\u0012': {
                    continue block56;
                }
                case '\u0013': {
                    continue block56;
                }
                case '\u0014': {
                    continue block56;
                }
                case '\u0015': {
                    continue block56;
                }
                case '\u0016': {
                    continue block56;
                }
                case '\u0017': {
                    continue block56;
                }
                case '\u0018': {
                    continue block56;
                }
                case '\u0019': {
                    continue block56;
                }
                case '\u001a': {
                    continue block56;
                }
                case '\u001b': {
                    continue block56;
                }
                case '\u001c': {
                    continue block56;
                }
                case '\u001d': {
                    continue block56;
                }
                case '\u001e': {
                    continue block56;
                }
                case '\u001f': {
                    continue block56;
                }
                case ' ': {
                    stringBuilder.append(' ');
                    continue block56;
                }
                case '!': {
                    stringBuilder.append('!');
                    continue block56;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block56;
                }
                case '#': {
                    stringBuilder.append('#');
                    continue block56;
                }
                case '$': {
                    stringBuilder.append('$');
                    continue block56;
                }
                case '%': {
                    stringBuilder.append('%');
                    continue block56;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block56;
                }
                case '\'': {
                    stringBuilder.append('\'');
                    continue block56;
                }
                case '(': {
                    stringBuilder.append('(');
                    continue block56;
                }
                case ')': {
                    stringBuilder.append(')');
                    continue block56;
                }
                case '*': {
                    stringBuilder.append('*');
                    continue block56;
                }
                case '+': {
                    stringBuilder.append('+');
                    continue block56;
                }
                case ',': {
                    stringBuilder.append(',');
                    continue block56;
                }
                case '-': {
                    stringBuilder.append('-');
                    continue block56;
                }
                case '.': {
                    stringBuilder.append('.');
                    continue block56;
                }
                case '/': {
                    stringBuilder.append('/');
                    continue block56;
                }
                case '0': {
                    stringBuilder.append('0');
                    continue block56;
                }
                case '1': {
                    stringBuilder.append('1');
                    continue block56;
                }
                case '2': {
                    stringBuilder.append('2');
                    continue block56;
                }
                case '3': {
                    stringBuilder.append('3');
                    continue block56;
                }
                case '4': {
                    stringBuilder.append('4');
                    continue block56;
                }
                case '5': {
                    stringBuilder.append('5');
                    continue block56;
                }
                case '6': {
                    stringBuilder.append('6');
                    continue block56;
                }
                case '7': {
                    stringBuilder.append('7');
                    continue block56;
                }
                case '8': {
                    stringBuilder.append('8');
                    continue block56;
                }
                case '9': {
                    stringBuilder.append('9');
                    continue block56;
                }
                case ':': {
                    stringBuilder.append(':');
                    continue block56;
                }
                case ';': {
                    stringBuilder.append(';');
                    continue block56;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block56;
                }
                case '=': {
                    stringBuilder.append('=');
                    continue block56;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block56;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    @Override
    boolean isAttribute() {
        return true;
    }

    public static final class Type {
        public static final Type CDATA = new Type(1);
        public static final Type ID = new Type(2);
        public static final Type IDREF = new Type(3);
        public static final Type IDREFS = new Type(4);
        public static final Type NMTOKEN = new Type(5);
        public static final Type NMTOKENS = new Type(6);
        public static final Type NOTATION = new Type(7);
        public static final Type ENTITY = new Type(8);
        public static final Type ENTITIES = new Type(9);
        public static final Type ENUMERATION = new Type(10);
        public static final Type UNDECLARED = new Type(0);
        private final int type;

        public String getName() {
            switch (this.type) {
                case 0: {
                    return "UNDECLARED";
                }
                case 1: {
                    return "CDATA";
                }
                case 2: {
                    return "ID";
                }
                case 3: {
                    return "IDREF";
                }
                case 4: {
                    return "IDREFS";
                }
                case 5: {
                    return "NMTOKEN";
                }
                case 6: {
                    return "NMTOKENS";
                }
                case 7: {
                    return "NOTATION";
                }
                case 8: {
                    return "ENTITY";
                }
                case 9: {
                    return "ENTITIES";
                }
                case 10: {
                    return "ENUMERATION";
                }
            }
            throw new RuntimeException("Bug in XOM: unexpected attribute type: " + this.type);
        }

        private Type(int n) {
            this.type = n;
        }

        public int hashCode() {
            return this.type;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.hashCode() != object.hashCode()) {
                return false;
            }
            return object.getClass().getName().equals("sqsaml.nu.xom.Attribute.Type");
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("[Attribute.Type: ");
            stringBuilder.append(this.getName());
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

