/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.saml.properties;

import java.util.Set;
import org.squashtest.tm.plugin.saml.properties.HttpClientConf;
import org.squashtest.tm.plugin.saml.properties.MetadataProperties;
import org.squashtest.tm.plugin.saml.properties.TrustedKeys;
import org.squashtest.tm.plugin.saml.properties.Utils;
import sqsaml.org.springframework.security.saml.metadata.ExtendedMetadata;
import sqsaml.org.springframework.security.saml.metadata.ExtendedMetadataDelegate;

public class IDPProperties {
    private String signingKey;
    private String encryptionKey;
    private Set<String> trustedKeys;
    private boolean requireLogoutRequestSigned = true;
    private boolean requireLogoutResponseSigned = false;
    private boolean requireArtifactResolveSigned = true;
    private boolean allowIdpInitiatedSso = true;
    private String proxyHost;
    private int proxyPort = 8080;
    private String basicUsername;
    private String basicPassword;
    private MetadataProperties metadata = new MetadataProperties();

    public String getSigningKey() {
        return Utils.nullIfBlank(this.signingKey);
    }

    public void setSigningKey(String signingKey) {
        this.signingKey = signingKey;
    }

    public String getEncryptionKey() {
        return Utils.nullIfBlank(this.encryptionKey);
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public Set<String> getTrustedKeys() {
        return this.trustedKeys;
    }

    public void setTrustedKeys(Set<String> trustedKeys) {
        this.trustedKeys = trustedKeys;
    }

    public boolean isRequireLogoutRequestSigned() {
        return this.requireLogoutRequestSigned;
    }

    public void setRequireLogoutRequestSigned(boolean requireLogoutRequestSigned) {
        this.requireLogoutRequestSigned = requireLogoutRequestSigned;
    }

    public boolean isRequireLogoutResponseSigned() {
        return this.requireLogoutResponseSigned;
    }

    public void setRequireLogoutResponseSigned(boolean requireLogoutResponseSigned) {
        this.requireLogoutResponseSigned = requireLogoutResponseSigned;
    }

    public boolean isRequireArtifactResolveSigned() {
        return this.requireArtifactResolveSigned;
    }

    public void setRequireArtifactResolveSigned(boolean requireArtifactResolveSigned) {
        this.requireArtifactResolveSigned = requireArtifactResolveSigned;
    }

    public boolean isAllowIdpInitiatedSso() {
        return this.allowIdpInitiatedSso;
    }

    public void setAllowIdpInitiatedSso(boolean allowIdpInitiatedSso) {
        this.allowIdpInitiatedSso = allowIdpInitiatedSso;
    }

    public MetadataProperties getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataProperties metadata) {
        this.metadata = metadata;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getBasicUsername() {
        return this.basicUsername;
    }

    public void setBasicUsername(String basicUsername) {
        this.basicUsername = basicUsername;
    }

    public String getBasicPassword() {
        return this.basicPassword;
    }

    public void setBasicPassword(String basicPassword) {
        this.basicPassword = basicPassword;
    }

    public HttpClientConf getHttpConf() {
        return new HttpClientConf(this.proxyHost, this.proxyPort, this.basicUsername, this.basicPassword);
    }

    public void configure(ExtendedMetadata meta) {
        meta.setLocal(false);
        meta.setSigningKey(this.signingKey);
        meta.setEncryptionKey(this.encryptionKey);
        meta.setTrustedKeys(TrustedKeys.toSpringTrustedKeys(this.trustedKeys));
        meta.setRequireLogoutRequestSigned(this.requireLogoutRequestSigned);
        meta.setRequireLogoutResponseSigned(this.requireLogoutResponseSigned);
        meta.setRequireArtifactResolveSigned(this.requireArtifactResolveSigned);
        meta.setSupportUnsolicitedResponse(this.allowIdpInitiatedSso);
    }

    public void configure(ExtendedMetadataDelegate delegate) {
        delegate.setMetadataRequireSignature(this.metadata.isRequireSignature());
        delegate.setMetadataTrustCheck(this.metadata.isCheckSignature());
        delegate.setForceMetadataRevocationCheck(this.metadata.isCheckCertificateRevocation());
        delegate.setMetadataTrustedKeys(TrustedKeys.toSpringTrustedKeys(this.metadata.getTrustedKeys()));
        delegate.setRequireValidMetadata(true);
    }
}

