/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Arrays;
import javax.crypto.Mac;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sqsaml.org.bouncycastle.util.encoders.Hex;

public final class SigningUtil {
    private SigningUtil() {
    }

    public static byte[] signWithURI(Credential signingCredential, String algorithmURI, byte[] input) throws SecurityException {
        String jcaAlgorithmID = SecurityHelper.getAlgorithmIDFromURI(algorithmURI);
        if (jcaAlgorithmID == null) {
            throw new SecurityException("Could not derive JCA algorithm identifier from algorithm URI");
        }
        boolean isHMAC = SecurityHelper.isHMAC(algorithmURI);
        return SigningUtil.sign(signingCredential, jcaAlgorithmID, isHMAC, input);
    }

    public static byte[] sign(Credential signingCredential, String jcaAlgorithmID, boolean isMAC, byte[] input) throws SecurityException {
        Logger log = SigningUtil.getLogger();
        Key signingKey = SecurityHelper.extractSigningKey(signingCredential);
        if (signingKey == null) {
            log.error("No signing key supplied in signing credential for signature computation");
            throw new SecurityException("No signing key supplied in signing credential");
        }
        if (isMAC) {
            return SigningUtil.signMAC(signingKey, jcaAlgorithmID, input);
        }
        if (signingKey instanceof PrivateKey) {
            return SigningUtil.sign((PrivateKey)signingKey, jcaAlgorithmID, input);
        }
        log.error("No PrivateKey present in signing credential for signature computation");
        throw new SecurityException("No PrivateKey supplied for signing");
    }

    public static byte[] sign(PrivateKey signingKey, String jcaAlgorithmID, byte[] input) throws SecurityException {
        Logger log = SigningUtil.getLogger();
        log.debug("Computing signature over input using private key of type {} and JCA algorithm ID {}", (Object)signingKey.getAlgorithm(), (Object)jcaAlgorithmID);
        try {
            Signature signature = Signature.getInstance(jcaAlgorithmID);
            signature.initSign(signingKey);
            signature.update(input);
            byte[] rawSignature = signature.sign();
            log.debug("Computed signature: {}", (Object)new String(Hex.encode(rawSignature)));
            return rawSignature;
        }
        catch (GeneralSecurityException e) {
            log.error("Error during signature generation", (Throwable)e);
            throw new SecurityException("Error during signature generation", e);
        }
    }

    public static byte[] signMAC(Key signingKey, String jcaAlgorithmID, byte[] input) throws SecurityException {
        Logger log = SigningUtil.getLogger();
        log.debug("Computing MAC over input using key of type {} and JCA algorithm ID {}", (Object)signingKey.getAlgorithm(), (Object)jcaAlgorithmID);
        try {
            Mac mac = Mac.getInstance(jcaAlgorithmID);
            mac.init(signingKey);
            mac.update(input);
            byte[] rawMAC = mac.doFinal();
            log.debug("Computed MAC: {}", (Object)new String(Hex.encode(rawMAC)));
            return rawMAC;
        }
        catch (GeneralSecurityException e) {
            log.error("Error during MAC generation", (Throwable)e);
            throw new SecurityException("Error during MAC generation", e);
        }
    }

    public static boolean verifyWithURI(Credential verificationCredential, String algorithmURI, byte[] signature, byte[] input) throws SecurityException {
        String jcaAlgorithmID = SecurityHelper.getAlgorithmIDFromURI(algorithmURI);
        if (jcaAlgorithmID == null) {
            throw new SecurityException("Could not derive JCA algorithm identifier from algorithm URI");
        }
        boolean isHMAC = SecurityHelper.isHMAC(algorithmURI);
        return SigningUtil.verify(verificationCredential, jcaAlgorithmID, isHMAC, signature, input);
    }

    public static boolean verify(Credential verificationCredential, String jcaAlgorithmID, boolean isMAC, byte[] signature, byte[] input) throws SecurityException {
        Logger log = SigningUtil.getLogger();
        Key verificationKey = SecurityHelper.extractVerificationKey(verificationCredential);
        if (verificationKey == null) {
            log.error("No verification key supplied in verification credential for signature verification");
            throw new SecurityException("No verification key supplied in verification credential");
        }
        if (isMAC) {
            return SigningUtil.verifyMAC(verificationKey, jcaAlgorithmID, signature, input);
        }
        if (verificationKey instanceof PublicKey) {
            return SigningUtil.verify((PublicKey)verificationKey, jcaAlgorithmID, signature, input);
        }
        log.error("No PublicKey present in verification credential for signature verification");
        throw new SecurityException("No PublicKey supplied for signature verification");
    }

    public static boolean verify(PublicKey verificationKey, String jcaAlgorithmID, byte[] signature, byte[] input) throws SecurityException {
        Logger log = SigningUtil.getLogger();
        log.debug("Verifying signature over input using public key of type {} and JCA algorithm ID {}", (Object)verificationKey.getAlgorithm(), (Object)jcaAlgorithmID);
        try {
            Signature sig = Signature.getInstance(jcaAlgorithmID);
            sig.initVerify(verificationKey);
            sig.update(input);
            return sig.verify(signature);
        }
        catch (GeneralSecurityException e) {
            log.error("Error during signature verification", (Throwable)e);
            throw new SecurityException("Error during signature verification", e);
        }
    }

    public static boolean verifyMAC(Key verificationKey, String jcaAlgorithmID, byte[] signature, byte[] input) throws SecurityException {
        Logger log = SigningUtil.getLogger();
        log.debug("Verifying MAC over input using key of type {} and JCA algorithm ID {}", (Object)verificationKey.getAlgorithm(), (Object)jcaAlgorithmID);
        byte[] computed = SigningUtil.signMAC(verificationKey, jcaAlgorithmID, input);
        return Arrays.equals(computed, signature);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(SigningUtil.class);
    }
}

