/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.liberty.binding.encoding;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.encoding.BaseSAML2MessageEncoder;
import org.opensaml.saml2.binding.encoding.HTTPSOAP11Encoder;
import org.opensaml.saml2.ecp.RelayState;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.soap.common.SOAPObjectBuilder;
import org.opensaml.ws.soap.soap11.Body;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.soap.util.SOAPHelper;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HTTPTransportUtils;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTTPPAOS11Encoder
extends BaseSAML2MessageEncoder {
    private final Logger log = LoggerFactory.getLogger(HTTPSOAP11Encoder.class);

    @Override
    protected void doEncode(MessageContext messageContext) throws MessageEncodingException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.error("Invalid message context type, this encoder only support SAMLMessageContext");
            throw new MessageEncodingException("Invalid message context type, this encoder only support SAMLMessageContext");
        }
        if (!(messageContext.getOutboundMessageTransport() instanceof HTTPOutTransport)) {
            this.log.error("Invalid outbound message transport type, this encoder only support HTTPOutTransport");
            throw new MessageEncodingException("Invalid outbound message transport type, this encoder only support HTTPOutTransport");
        }
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        Object samlMessage = samlMsgCtx.getOutboundSAMLMessage();
        if (samlMessage == null) {
            throw new MessageEncodingException("No outbound SAML message contained in message context");
        }
        if (samlMsgCtx.getRelayState() != null) {
            SOAPHelper.addHeaderBlock(samlMsgCtx, this.getRelayState(samlMsgCtx.getRelayState()));
        }
        this.signMessage(samlMsgCtx);
        XMLObject outboundEnveloppe = samlMsgCtx.getOutboundMessage();
        Envelope envelope = this.buildPAOSMessage((SAMLObject)samlMessage, outboundEnveloppe);
        Element envelopeElem = this.marshallMessage(envelope);
        try {
            HTTPOutTransport outTransport = (HTTPOutTransport)messageContext.getOutboundMessageTransport();
            HTTPTransportUtils.addNoCacheHeaders(outTransport);
            HTTPTransportUtils.setUTF8Encoding(outTransport);
            HTTPTransportUtils.setContentType(outTransport, "text/xml");
            outTransport.setHeader("SOAPAction", "https://www.oasis-open.org/committees/security");
            OutputStreamWriter out = new OutputStreamWriter(outTransport.getOutgoingStream(), "UTF-8");
            XMLHelper.writeNode((Node)envelopeElem, out);
            ((Writer)out).flush();
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("JVM does not support required UTF-8 encoding");
            throw new MessageEncodingException("JVM does not support required UTF-8 encoding");
        }
        catch (IOException e) {
            this.log.error("Unable to write message content to outbound stream", (Throwable)e);
            throw new MessageEncodingException("Unable to write message content to outbound stream", e);
        }
    }

    protected RelayState getRelayState(String relayStateValue) {
        if (relayStateValue == null) {
            throw new IllegalArgumentException("RelayStateValue can't be null");
        }
        if (relayStateValue.length() > 80) {
            throw new IllegalArgumentException("Relay state can't exceed size 80 when using ECP profile");
        }
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        SAMLObjectBuilder relayStateBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(RelayState.DEFAULT_ELEMENT_NAME);
        RelayState relayState = (RelayState)relayStateBuilder.buildObject();
        relayState.setSOAP11Actor("http://schemas.xmlsoap.org/soap/actor/next");
        relayState.setSOAP11MustUnderstand(true);
        relayState.setValue(relayStateValue);
        return relayState;
    }

    protected Envelope buildPAOSMessage(SAMLObject samlMessage, XMLObject outboundEnvelope) {
        Envelope envelope;
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        if (outboundEnvelope != null && outboundEnvelope instanceof Envelope) {
            envelope = (Envelope)outboundEnvelope;
        } else {
            SOAPObjectBuilder envBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME);
            envelope = (Envelope)envBuilder.buildObject();
        }
        SOAPObjectBuilder bodyBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Body.DEFAULT_ELEMENT_NAME);
        Body body = (Body)bodyBuilder.buildObject();
        body.getUnknownXMLObjects().add(samlMessage);
        envelope.setBody(body);
        return envelope;
    }

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:PAOS";
    }

    @Override
    public boolean providesMessageConfidentiality(MessageContext messageContext) throws MessageEncodingException {
        return messageContext.getOutboundMessageTransport().isConfidential();
    }

    @Override
    public boolean providesMessageIntegrity(MessageContext messageContext) throws MessageEncodingException {
        return messageContext.getOutboundMessageTransport().isIntegrityProtected();
    }
}

