/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.saml;

import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.saml2.provider.service.authentication.OpenSaml4AuthenticationProvider;
import org.squashtest.tm.plugin.saml.SAMLProviderFeatures;
import org.squashtest.tm.plugin.saml.SquashSAMLUserDetailsService;
import org.squashtest.tm.plugin.saml.SquashSamlAuthenticationProvider;
import org.squashtest.tm.plugin.saml.properties.SessionProperties;

public class SquashSamlProviderPostProcessor
implements ObjectPostProcessor<AuthenticationProvider> {
    private final SquashSAMLUserDetailsService samlUserDetailsService;
    private final SAMLProviderFeatures features;
    private final SessionProperties sessionProperties;

    public SquashSamlProviderPostProcessor(SquashSAMLUserDetailsService samlUserDetailsService, SAMLProviderFeatures features, SessionProperties sessionProperties) {
        this.samlUserDetailsService = samlUserDetailsService;
        this.features = features;
        this.sessionProperties = sessionProperties;
    }

    public <O extends AuthenticationProvider> O postProcess(O object) {
        if (object instanceof OpenSaml4AuthenticationProvider) {
            OpenSaml4AuthenticationProvider provider = (OpenSaml4AuthenticationProvider)object;
            SquashSamlAuthenticationProvider squashSamlProvider = new SquashSamlAuthenticationProvider(provider, this.samlUserDetailsService, this.features);
            squashSamlProvider.setAssertionValidator(this.sessionProperties);
            return (O)squashSamlProvider;
        }
        return object;
    }
}

