/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.saml;

import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;
import org.squashtest.tm.plugin.saml.SAMLProviderFeatures;
import org.squashtest.tm.plugin.saml.beans.ExtraAccountInformation;
import org.squashtest.tm.plugin.saml.beans.ExtraAccountInformationSAMLExpirationToken;
import org.squashtest.tm.plugin.saml.beans.ExtraAccountInformationUser;
import org.squashtest.tm.plugin.saml.beans.FeatureAwareSAMLExpirationToken;

public class SquashSAMLAuthProvider {
    private final SAMLProviderFeatures features;

    public SquashSAMLAuthProvider(SAMLProviderFeatures features) {
        this.features = features;
    }

    public FeatureAwareSAMLExpirationToken authenticate(Saml2Authentication authentication, UserDetails user) throws AuthenticationException {
        FeatureAwareSAMLExpirationToken augmentedAuth;
        if (this.containsExtraInfo(user)) {
            ExtraAccountInformation extraInformation = this.retrieveExtraInformation(user);
            augmentedAuth = new ExtraAccountInformationSAMLExpirationToken(authentication, this.features, user.getAuthorities(), extraInformation);
        } else {
            augmentedAuth = new FeatureAwareSAMLExpirationToken(authentication, this.features, user.getAuthorities());
        }
        return augmentedAuth;
    }

    private boolean containsExtraInfo(UserDetails user) {
        return ExtraAccountInformationUser.class.isAssignableFrom(user.getClass());
    }

    private ExtraAccountInformation retrieveExtraInformation(UserDetails user) {
        return ((ExtraAccountInformationUser)user).getExtraInformation();
    }
}

