/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.saml;

import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.impl.AuthnStatementValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.saml2.Saml2LoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.saml2.Saml2LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.saml2.Saml2MetadataConfigurer;
import org.springframework.security.converter.RsaKeyConverters;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.core.Saml2ResponseValidatorResult;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.authentication.DefaultSaml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.OpenSaml4AuthenticationProvider;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;
import org.springframework.security.saml2.provider.service.registration.InMemoryRelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrations;
import org.springframework.security.saml2.provider.service.web.DefaultRelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.authentication.OpenSaml4AuthenticationRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.Saml2AuthenticationRequestResolver;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.squashtest.tm.plugin.saml.SAMLActivationSwitch;
import org.squashtest.tm.plugin.saml.SAMLProviderFeatures;
import org.squashtest.tm.plugin.saml.SquashSAMLAuthProvider;
import org.squashtest.tm.plugin.saml.SquashSAMLUserDetailsService;
import org.squashtest.tm.plugin.saml.beans.FeatureAwareSAMLExpirationToken;
import org.squashtest.tm.plugin.saml.config.SamlLoginRedirectFilter;
import org.squashtest.tm.plugin.saml.properties.DefaultWebSSOProfileOptions;
import org.squashtest.tm.plugin.saml.properties.MetadataProperties;
import org.squashtest.tm.plugin.saml.properties.ReverseProxyProperties;
import org.squashtest.tm.plugin.saml.properties.SAMLProperties;
import org.squashtest.tm.plugin.saml.properties.SPProperties;
import org.squashtest.tm.plugin.saml.properties.SessionProperties;

@Configuration
@EnableConfigurationProperties(value={SAMLProperties.class})
@SAMLActivationSwitch
public class SAMLConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAMLConfig.class);
    public static final String SAML_PROVIDER_NAME = "saml";
    private static final String METADATA_URL = "/auth/saml/metadata/{registrationId}";
    private static final String LOGIN_PROCESSING_URL = "/auth/saml/sso/{registrationId}";
    private static final String SINGLE_LOGOUT_PROCESSING_URL = "/auth/saml/SingleLogout";
    private static final String AUTHENTICATION_REQUEST_URI = "/auth/saml/login/{registrationId}";
    private final SAMLProperties samlProperties;
    private final UserDetailsService userDetailsService;

    public SAMLConfig(SAMLProperties samlProperties, UserDetailsService userDetailsService) {
        this.samlProperties = samlProperties;
        this.userDetailsService = userDetailsService;
    }

    @Bean
    @Order(value=28)
    public SecurityFilterChain samlSecurityFilterChain(HttpSecurity http) throws Exception {
        http.securityMatcher(new String[]{"/auth/saml/**"}).authorizeHttpRequests(authz -> {
            AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.requestMatchers(new String[]{"/auth/saml/authentication-failure"})).permitAll().anyRequest()).authenticated();
        }).authenticationProvider((AuthenticationProvider)this.samlAuthenticationProvider()).saml2Login(saml2 -> {
            AbstractAuthenticationFilterConfigurer abstractAuthenticationFilterConfigurer = ((Saml2LoginConfigurer)saml2.loginProcessingUrl(LOGIN_PROCESSING_URL).authenticationRequestUri(AUTHENTICATION_REQUEST_URI).successHandler((AuthenticationSuccessHandler)this.samlSuccessRedirectHandler())).failureHandler((AuthenticationFailureHandler)this.samlAuthenticationFailureHandler());
        }).saml2Metadata(saml2 -> {
            Saml2MetadataConfigurer saml2MetadataConfigurer = saml2.metadataUrl(METADATA_URL);
        }).saml2Logout(logout -> {
            Saml2LogoutConfigurer saml2LogoutConfigurer = logout.logoutRequest(req -> {
                Saml2LogoutConfigurer.LogoutRequestConfigurer logoutRequestConfigurer = req.logoutUrl(SINGLE_LOGOUT_PROCESSING_URL);
            });
        });
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public Saml2AuthenticationRequestResolver authenticationRequestResolver(RelyingPartyRegistrationRepository registrations) {
        DefaultRelyingPartyRegistrationResolver registrationResolver = new DefaultRelyingPartyRegistrationResolver(registrations);
        OpenSaml4AuthenticationRequestResolver resolver = new OpenSaml4AuthenticationRequestResolver((RelyingPartyRegistrationResolver)registrationResolver);
        resolver.setRequestMatcher((RequestMatcher)new AntPathRequestMatcher(AUTHENTICATION_REQUEST_URI));
        DefaultWebSSOProfileOptions sso = this.samlProperties.getSso();
        resolver.setAuthnRequestCustomizer(context -> sso.configureAuthnRequest(context.getAuthnRequest()));
        if (sso.containRelayState()) {
            resolver.setRelayStateResolver(request -> request.getParameter(sso.getRelayState()));
        }
        return resolver;
    }

    public OpenSaml4AuthenticationProvider samlAuthenticationProvider() {
        OpenSaml4AuthenticationProvider authenticationProvider = new OpenSaml4AuthenticationProvider();
        authenticationProvider.setResponseAuthenticationConverter(this::authenticationConverter);
        authenticationProvider.setAssertionValidator(this::buildValidator);
        return authenticationProvider;
    }

    private FeatureAwareSAMLExpirationToken authenticationConverter(OpenSaml4AuthenticationProvider.ResponseToken responseToken) {
        Saml2Authentication authentication = (Saml2Authentication)OpenSaml4AuthenticationProvider.createDefaultResponseAuthenticationConverter().convert((Object)responseToken);
        DefaultSaml2AuthenticatedPrincipal samlPrincipal = (DefaultSaml2AuthenticatedPrincipal)authentication.getPrincipal();
        UserDetails userDetails = this.samlUserDetailsService().loadUserBySAML(samlPrincipal);
        SquashSAMLAuthProvider squashSAMLProvider = new SquashSAMLAuthProvider(this.samlProviderFeatures());
        return squashSAMLProvider.authenticate(authentication, userDetails);
    }

    @Bean
    public SquashSAMLUserDetailsService samlUserDetailsService() {
        return new SquashSAMLUserDetailsService(this.samlProperties.getUserMapping(), this.userDetailsService);
    }

    private Saml2ResponseValidatorResult buildValidator(OpenSaml4AuthenticationProvider.AssertionToken assertionToken) {
        SessionProperties session = this.samlProperties.getSession();
        Saml2ResponseValidatorResult result = (Saml2ResponseValidatorResult)OpenSaml4AuthenticationProvider.createDefaultAssertionValidatorWithParameters(params -> {
            params.put("saml2.ClockSkew", Duration.ofSeconds(session.getClockSkew()));
            params.put("saml2.Lifetime", Duration.ofSeconds(session.getMaxAssertionTime()));
        }).convert((Object)assertionToken);
        if (result.hasErrors()) {
            return result;
        }
        Assertion assertion = assertionToken.getAssertion();
        AuthnStatementValidator authnStatementValidator = new AuthnStatementValidator();
        ValidationContext context = new ValidationContext(Map.of("saml2.Statement.Authn.MaxTimeSinceAuthn", Duration.ofSeconds(session.getMaxAuthTime())));
        List authnStatement = assertion.getAuthnStatements();
        for (AuthnStatement statement : authnStatement) {
            try {
                if (authnStatementValidator.validate((Statement)statement, assertion, context) == ValidationResult.VALID) continue;
                String message = "Invalid assertion for SAML response: Authentication statement is too old";
                return Saml2ResponseValidatorResult.failure((Saml2Error[])new Saml2Error[]{new Saml2Error("invalid_assertion", message)});
            }
            catch (Exception e) {
                LOGGER.error("Error validating authentication statement assertion", (Throwable)e);
                String message = String.format("Invalid assertion for SAML response : %s", e.getMessage());
                return Saml2ResponseValidatorResult.failure((Saml2Error[])new Saml2Error[]{new Saml2Error("invalid_assertion", message)});
            }
        }
        return result;
    }

    @Bean
    public RelyingPartyRegistrationRepository relyingPartyRegistrations() {
        LOGGER.info("initializing : relyingPartyRegistrationRepository");
        String idpMetadataUrl = this.samlProperties.getIdp().getMetadataUrl();
        SPProperties sp = this.samlProperties.getSp();
        MetadataProperties spMetadata = sp.getMetadata();
        String baseUrl = this.buildBaseUrl();
        RelyingPartyRegistration.Builder builder = RelyingPartyRegistrations.fromMetadataLocation((String)idpMetadataUrl).registrationId(sp.getRegistrationId()).entityId(sp.getEntityId()).assertionConsumerServiceLocation(baseUrl + LOGIN_PROCESSING_URL).singleLogoutServiceLocation(baseUrl + SINGLE_LOGOUT_PROCESSING_URL);
        this.configureCredentials(builder);
        spMetadata.configureAdditionalProperties(builder);
        return new InMemoryRelyingPartyRegistrationRepository(new RelyingPartyRegistration[]{builder.build()});
    }

    private String buildBaseUrl() {
        ReverseProxyProperties proxy = this.samlProperties.getProxy();
        if (!proxy.isEnabled()) {
            return "{baseUrl}";
        }
        LOGGER.trace("Building base URL with proxy settings");
        StringBuilder baseUrl = new StringBuilder();
        baseUrl.append(proxy.getScheme()).append("://").append(proxy.getServerName());
        if (proxy.isIncludePortInUrl()) {
            baseUrl.append(":").append(proxy.getServerPort());
        }
        baseUrl.append(proxy.getContextPath());
        return baseUrl.toString();
    }

    private void configureCredentials(RelyingPartyRegistration.Builder builder) {
        MetadataProperties spMetadata = this.samlProperties.getSp().getMetadata();
        try {
            RSAPrivateKey privateKey = this.readPrivateKey(spMetadata.getPrivateKey());
            X509Certificate certificate = this.readCertificate(spMetadata.getCertificate());
            Saml2X509Credential signingCredential = Saml2X509Credential.signing((PrivateKey)privateKey, (X509Certificate)certificate);
            Saml2X509Credential decryptionCredential = Saml2X509Credential.decryption((PrivateKey)privateKey, (X509Certificate)certificate);
            builder.signingX509Credentials(creds -> {
                boolean bl = creds.add(signingCredential);
            });
            builder.decryptionX509Credentials(creds -> {
                boolean bl = creds.add(decryptionCredential);
            });
        }
        catch (Exception e) {
            throw new Saml2Exception("Error loading credentials", (Throwable)e);
        }
    }

    private RSAPrivateKey readPrivateKey(Resource location) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = location.getInputStream();){
                return (RSAPrivateKey)RsaKeyConverters.pkcs8().convert((Object)inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private X509Certificate readCertificate(Resource location) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = location.getInputStream();){
                return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Bean
    @ConditionalOnProperty(value={"authentication.provider"}, havingValue="saml")
    public SamlLoginRedirectFilter samlLoginRedirectFilter() {
        LOGGER.info("initializing : samlLoginRedirectFilter");
        return new SamlLoginRedirectFilter(this.samlProperties.getSp().getRegistrationId());
    }

    @Bean
    public SavedRequestAwareAuthenticationSuccessHandler samlSuccessRedirectHandler() {
        LOGGER.info("initializing : samlSuccessRedirectHandler");
        SavedRequestAwareAuthenticationSuccessHandler successRedirectHandler = new SavedRequestAwareAuthenticationSuccessHandler();
        successRedirectHandler.setDefaultTargetUrl("/home-workspace");
        return successRedirectHandler;
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler samlAuthenticationFailureHandler() {
        LOGGER.info("initializing : samlAuthenticationFailureHandler");
        SimpleUrlAuthenticationFailureHandler failureHandler = new SimpleUrlAuthenticationFailureHandler();
        failureHandler.setDefaultFailureUrl("/auth/saml/authentication-failure");
        return failureHandler;
    }

    @Bean
    public SAMLProviderFeatures samlProviderFeatures() {
        return new SAMLProviderFeatures();
    }
}

