/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.openid.connect.service;

import jakarta.inject.Inject;
import java.util.Objects;
import org.springframework.context.annotation.Primary;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.user.SuccessfulAuthConnectionManagerService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.user.UserManagerService;

@Service
@Primary
public class SuccessfulAuthConnectionManagerServiceImpl
implements SuccessfulAuthConnectionManagerService {
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private UserManagerService userManagerService;

    public void manageSuccessfulAuthConnection(InteractiveAuthenticationSuccessEvent event) {
        boolean isOAuth2Token = event.getSource() instanceof OAuth2AuthenticationToken;
        if (isOAuth2Token) {
            OAuth2AuthenticationToken token = (OAuth2AuthenticationToken)event.getSource();
            String oauth2login = token.getPrincipal().getName();
            User user = this.userManagerService.findByLogin(oauth2login);
            if (Objects.nonNull(user)) {
                this.userAccountService.updateUserLastConnectionDate();
            }
        } else {
            this.userAccountService.updateUserLastConnectionDate();
        }
    }
}

