/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.security.ldap;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.AuthenticationException;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.OperationNotSupportedException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticator;
import org.springframework.security.ldap.ppolicy.PasswordPolicyControlExtractor;
import org.springframework.security.ldap.ppolicy.PasswordPolicyResponseControl;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BlindBindAuthenticator
extends AbstractLdapAuthenticator {
    private static final Log logger = LogFactory.getLog(BlindBindAuthenticator.class);

    public BlindBindAuthenticator(BaseLdapPathContextSource contextSource) {
        super((ContextSource)contextSource);
    }

    public DirContextOperations authenticate(Authentication authentication) {
        DirContextOperations user = null;
        Assert.isInstanceOf(UsernamePasswordAuthenticationToken.class, (Object)authentication, (String)"Can only process UsernamePasswordAuthenticationToken objects");
        String username = authentication.getName();
        String password = (String)authentication.getCredentials();
        if (!StringUtils.hasLength((String)password)) {
            logger.debug((Object)("Rejecting empty password for user " + username));
            throw new BadCredentialsException(this.messages.getMessage("BindAuthenticator.emptyPassword", "Empty Password"));
        }
        for (String dn : this.getUserDns(username)) {
            user = this.bindWithDn(dn, username, password);
            if (user != null) break;
        }
        if (user == null && this.getUserSearch() != null) {
            DirContextOperations userFromSearch = this.getUserSearch().searchForUser(username);
            user = this.bindWithDn(userFromSearch.getDn().toString(), username, password);
        }
        if (user == null) {
            throw new BadCredentialsException(this.messages.getMessage("BindAuthenticator.badCredentials", "Bad credentials"));
        }
        return user;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DirContextOperations bindWithDn(String userDnStr, String username, String password) {
        DirContextAdapter dirContextAdapter;
        BaseLdapPathContextSource ctxSource = (BaseLdapPathContextSource)this.getContextSource();
        LdapName base = ctxSource.getBaseLdapName();
        LdapName userDn = LdapUtils.newLdapName((String)userDnStr);
        LdapName fullDn = LdapUtils.newLdapName((Name)userDn);
        try {
            fullDn.addAll(0, base);
        }
        catch (InvalidNameException e) {
            this.handleBindException(userDnStr, username, e);
        }
        logger.debug((Object)("Attempting to bind as " + String.valueOf(fullDn)));
        DirContext ctx = null;
        try {
            ctx = ctxSource.getContext(fullDn.toString(), password);
            PasswordPolicyResponseControl ppolicy = PasswordPolicyControlExtractor.extractControl((DirContext)ctx);
            logger.debug((Object)"Skipping attributes retrieval");
            DirContextAdapter result = new DirContextAdapter(null, (Name)userDn, (Name)base);
            if (ppolicy != null) {
                result.setAttributeValue(ppolicy.getID(), (Object)ppolicy);
            }
            dirContextAdapter = result;
        }
        catch (NamingException e) {
            try {
                if (!(e instanceof AuthenticationException) && !(e instanceof OperationNotSupportedException)) {
                    throw e;
                }
                this.handleBindException(userDnStr, username, e);
            }
            catch (Throwable throwable) {
                LdapUtils.closeContext(ctx);
                throw throwable;
            }
            LdapUtils.closeContext((DirContext)ctx);
            return null;
        }
        LdapUtils.closeContext((DirContext)ctx);
        return dirContextAdapter;
    }

    protected void handleBindException(String userDn, String username, Throwable cause) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Failed to bind as " + userDn + ": " + String.valueOf(cause)));
        }
    }
}

