/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.security.ldap;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.squashtest.tm.api.security.authentication.ConditionalOnAuthProviderProperty;
import org.squashtest.tm.plugin.security.ldap.CaseAwareUserDetailsMapper;
import org.squashtest.tm.plugin.security.ldap.LdapAuthenticationProperties;
import org.squashtest.tm.plugin.security.ldap.LdapAuthenticationProviderFactoryBean;
import org.squashtest.tm.plugin.security.ldap.MultiLdapAuthenticationProviderFeatures;
import org.squashtest.tm.plugin.security.ldap.SquashLdapAuthenticationProvider;
import org.squashtest.tm.plugin.security.ldap.UserDetailsServiceLdapAuthoritiesPopulator;
import org.squashtest.tm.service.internal.security.SquashUserDetailsManager;
import org.squashtest.tm.service.security.UserDetailsService;
import org.squashtest.tm.service.user.UserManagerService;

@Configuration
@ConditionalOnAuthProviderProperty(value="ldap-multi")
@EnableConfigurationProperties(value={LdapAuthenticationProperties.class})
public class MultiLdapSecurityConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiLdapSecurityConfig.class);
    @Inject
    @Named(value="squashtest.core.security.JdbcUserDetailsManager")
    @Lazy
    private SquashUserDetailsManager userDetailsManager;
    @Inject
    @Named(value="caseAwareUserDetailsMapper.ldap")
    private CaseAwareUserDetailsMapper userDetailsMapper;
    @Value(value="${authentication.ldap.multi.root.names}")
    private String[] ldapRootNames;
    @Inject
    private Environment environment;
    @Inject
    @Lazy
    private UserManagerService userManagerService;

    @Configuration
    @ConditionalOnAuthProviderProperty(value="ldap-multi")
    @Order(value=1)
    public class LdapAuthenticationConfig
    extends GlobalAuthenticationConfigurerAdapter {
        private static final String SERVER_URL_KEY = "authentication.ldap.server.url";
        private static final String SERVER_MANAGER_DN_KEY = "authentication.ldap.server.managerDn";
        private static final String SERVER_MANAGER_PASSWORD_KEY = "authentication.ldap.server.managerPassword";
        private static final String USER_DN_PATTERNS_KEY = "authentication.ldap.user.dnPatterns";
        private static final String USER_SEARCH_BASE_KEY = "authentication.ldap.user.searchBase";
        private static final String USER_SEARCH_FILTER_KEY = "authentication.ldap.user.searchFilter";
        private static final String USER_FETCH_ATTRIBUTES_KEY = "authentication.ldap.user.fetchAttributes";

        public void configure(AuthenticationManagerBuilder auth) throws Exception {
            LOGGER.info("Multi LDAP configuration is enabled - Begin configuration ");
            this.checkLdapRootNames();
            String[] stringArray = MultiLdapSecurityConfig.this.ldapRootNames;
            int n = MultiLdapSecurityConfig.this.ldapRootNames.length;
            int n2 = 0;
            while (n2 < n) {
                String ldapRootName = stringArray[n2];
                LOGGER.info("Begin LDAP Configuration : " + ldapRootName);
                LdapAuthenticationProperties ldapAuthenticationProperties = this.getPropertiesForOneLdap(ldapRootName);
                DefaultSpringSecurityContextSource contextSource = this.createSpringSecurityContextSource(ldapAuthenticationProperties);
                SquashLdapAuthenticationProvider ldapAuthenticationProvider = this.createSquashLdapAuthenticationProvider(ldapAuthenticationProperties, contextSource);
                auth.authenticationProvider((AuthenticationProvider)ldapAuthenticationProvider);
                LOGGER.info("Ending LDAP Configuration : " + ldapRootName);
                ++n2;
            }
            auth.eraseCredentials(false);
            LOGGER.info("Multi LDAP configuration is enabled - End of configuration ");
        }

        private SquashLdapAuthenticationProvider createSquashLdapAuthenticationProvider(LdapAuthenticationProperties ldapAuthenticationProperties, DefaultSpringSecurityContextSource contextSource) throws Exception {
            LdapAuthenticationProviderFactoryBean factoryBean = new LdapAuthenticationProviderFactoryBean();
            factoryBean.setActiveAuthenticationProvider("ldap-multi");
            factoryBean.setContextSource((LdapContextSource)contextSource);
            factoryBean.setUserDnPatterns(ldapAuthenticationProperties.getUser().getDnPatterns());
            factoryBean.setUserSearchBase(ldapAuthenticationProperties.getUser().getSearchBase());
            factoryBean.setUserSearchFilter(ldapAuthenticationProperties.getUser().getSearchFilter());
            factoryBean.setFetchUserAttributes(ldapAuthenticationProperties.getUser().isFetchAttributes());
            factoryBean.setAuthoritiesPopulator(new UserDetailsServiceLdapAuthoritiesPopulator((UserDetailsService)MultiLdapSecurityConfig.this.userDetailsManager));
            factoryBean.setUserDetailsMapper(MultiLdapSecurityConfig.this.userDetailsMapper);
            factoryBean.setFeatures(this.multiLdapAuthenticationProviderFeatures());
            factoryBean.setUserManagerService(MultiLdapSecurityConfig.this.userManagerService);
            factoryBean.afterPropertiesSet();
            return factoryBean.getObject();
        }

        @Bean
        public MultiLdapAuthenticationProviderFeatures multiLdapAuthenticationProviderFeatures() {
            return MultiLdapAuthenticationProviderFeatures.INSTANCE;
        }

        private DefaultSpringSecurityContextSource createSpringSecurityContextSource(LdapAuthenticationProperties ldapAuthenticationProperties) throws Exception {
            DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(ldapAuthenticationProperties.getServer().getUrl());
            contextSource.setUserDn(ldapAuthenticationProperties.getServer().getManagerDn());
            contextSource.setPassword(ldapAuthenticationProperties.getServer().getManagerPassword());
            contextSource.afterPropertiesSet();
            return contextSource;
        }

        private LdapAuthenticationProperties getPropertiesForOneLdap(String ldapRootName) {
            LdapAuthenticationProperties ldapAuthenticationProperties = new LdapAuthenticationProperties();
            String serverUrl = this.getBaseNamedProperty(ldapRootName, SERVER_URL_KEY, String.class);
            this.logConfigurationParameter(ldapRootName, SERVER_URL_KEY, serverUrl);
            ldapAuthenticationProperties.getServer().setUrl(serverUrl);
            String managerDn = this.getBaseNamedProperty(ldapRootName, SERVER_MANAGER_DN_KEY, String.class);
            this.logConfigurationParameter(ldapRootName, SERVER_MANAGER_DN_KEY, managerDn);
            ldapAuthenticationProperties.getServer().setManagerDn(managerDn);
            String managerPassword = this.getBaseNamedProperty(ldapRootName, SERVER_MANAGER_PASSWORD_KEY, String.class);
            ldapAuthenticationProperties.getServer().setManagerPassword(managerPassword);
            String dnPatterns = this.getBaseNamedProperty(ldapRootName, USER_DN_PATTERNS_KEY, String.class);
            this.logConfigurationParameter(ldapRootName, USER_DN_PATTERNS_KEY, dnPatterns);
            ldapAuthenticationProperties.getUser().setDnPatterns(dnPatterns);
            String searchBase = this.getBaseNamedProperty(ldapRootName, USER_SEARCH_BASE_KEY, String.class);
            this.logConfigurationParameter(ldapRootName, USER_SEARCH_BASE_KEY, searchBase);
            ldapAuthenticationProperties.getUser().setSearchBase(searchBase);
            String searchFilter = this.getBaseNamedProperty(ldapRootName, USER_SEARCH_FILTER_KEY, String.class);
            this.logConfigurationParameter(ldapRootName, USER_SEARCH_FILTER_KEY, searchFilter);
            ldapAuthenticationProperties.getUser().setSearchFilter(searchFilter);
            Boolean isFetchAttributes = this.getBaseNamedProperty(ldapRootName, USER_FETCH_ATTRIBUTES_KEY, Boolean.class);
            this.logConfigurationParameter(ldapRootName, USER_SEARCH_FILTER_KEY, isFetchAttributes);
            if (isFetchAttributes != null) {
                ldapAuthenticationProperties.getUser().setFetchAttributes(isFetchAttributes);
            }
            return ldapAuthenticationProperties;
        }

        private void logConfigurationParameter(String ldapRootName, String rootKey, Object parameterValue) {
            if (parameterValue != null) {
                LOGGER.info("Loading conf for {}. Key: {}. Value in squash configuration: {}", new Object[]{ldapRootName, rootKey, parameterValue});
            } else {
                LOGGER.info("Loading conf for {}. Key: {}. Value in squash configuration is null. Default value will be used.", (Object)ldapRootName, (Object)rootKey);
            }
        }

        private <T> T getBaseNamedProperty(String ldapRootName, String propertyName, Class<T> type) {
            return (T)MultiLdapSecurityConfig.this.environment.getProperty(ldapRootName + "." + propertyName, type);
        }

        private void checkLdapRootNames() {
            if (MultiLdapSecurityConfig.this.ldapRootNames == null || MultiLdapSecurityConfig.this.ldapRootNames.length == 0) {
                throw new IllegalArgumentException("The property authentication.ldap.multi.root.names is mandatory when using ldap plugin in multi ldap mode.");
            }
        }
    }
}

