/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.campaignassessment.dto;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.plugin.report.campaignassessment.dto.GeneratedDates;

@Component
public class I18nHelper
implements MessageSourceAware {
    private MessageSource msgSource;

    public Locale currentLocale() {
        Locale current = LocaleContextHolder.getLocale();
        if (current == null) {
            current = Locale.getDefault();
        }
        return current;
    }

    public String translate(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        return this.msgSource.getMessage(string, null, this.currentLocale());
    }

    public String translateWithParams(String string, Object[] params) {
        return this.msgSource.getMessage(string, params, this.currentLocale());
    }

    public GeneratedDates buildGeneratedDates() {
        Date now = new Date();
        String fileNameFormat = new SimpleDateFormat(this.msgSource.getMessage("report.campaignassessment.file.dateformat", null, this.currentLocale())).format(now);
        String bottomPageFormat = new SimpleDateFormat(this.msgSource.getMessage("squashtm.dateformat", null, this.currentLocale())).format(now);
        String shortDate = this.translateDateShort(now);
        String hour = this.extractHour(bottomPageFormat);
        Object[] params = new String[]{shortDate, hour};
        String firstPageFormat = this.msgSource.getMessage("report.campaignassessment.generated.date.first.page", params, this.currentLocale());
        return new GeneratedDates(fileNameFormat, bottomPageFormat, firstPageFormat);
    }

    private String extractHour(String fullDate) {
        return fullDate.length() >= 16 ? fullDate.substring(11, 16) : "";
    }

    public String translateDateShort(Date date) {
        if (date == null) {
            return "";
        }
        String dateFormat = this.msgSource.getMessage("squashtm.dateformatShort", null, this.currentLocale());
        return new SimpleDateFormat(dateFormat).format(date);
    }

    public MessageSource getMsgSource() {
        return this.msgSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.msgSource = messageSource;
    }
}

