/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.premium.actionword.service.grid;

import java.util.Arrays;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;

public class KeywordStepsUsingActionWordGrid
extends AbstractGrid {
    private static final String AUTOMATION_STATUS = "AUTOMATION_STATUS";
    private static final String REMOTE_STATUS = "REMOTE_STATUS";
    private static final String DEDUCED_KEYWORD_TYPE = "KEYWORD_TYPE";
    private static final String GIVEN = "GIVEN";
    private static final String WHEN = "WHEN";
    private static final String THEN = "THEN";
    private static final String AND = "AND";
    private static final String BUT = "BUT";
    private static final String UNDEFINED = "UNDEFINED";
    private static final String PREVIOUS_STEP = "previous_step";
    private static final String PREVIOUS_KEYWORD_STEP = "previous_keyword_step";
    private final long actionWordId;

    public KeywordStepsUsingActionWordGrid(long actionWordId) {
        this.actionWordId = actionWordId;
    }

    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn(Tables.KEYWORD_TEST_STEP.TEST_STEP_ID.as("ID")), new GridColumn(Tables.TEST_CASE.TCLN_ID.as("TEST_CASE_ID")), new GridColumn(Tables.TEST_CASE_LIBRARY_NODE.NAME.as("TEST_CASE_NAME")), new GridColumn(Tables.PROJECT.NAME.as("PROJECT_NAME")), new GridColumn((Field)Tables.TEST_CASE.REFERENCE), new GridColumn(Tables.TEST_CASE.TC_STATUS.as("STATUS")), new GridColumn((Field)Tables.TEST_CASE.IMPORTANCE), new GridColumn((Field)Tables.TEST_CASE_STEPS.STEP_ORDER), new GridColumn(this.getResolvedKeywordType().as(DEDUCED_KEYWORD_TYPE)), new GridColumn(this.getAutomationStatus().as(AUTOMATION_STATUS)), new GridColumn(Tables.REMOTE_AUTOMATION_REQUEST_EXTENDER.REMOTE_STATUS.as(REMOTE_STATUS)), new GridColumn((Field)Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW), new GridColumn((Field)Tables.TEST_CASE.AUTOMATABLE));
    }

    protected Table<?> getTable() {
        return Tables.TEST_CASE.innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).innerJoin((TableLike)Tables.KEYWORD_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.KEYWORD_TEST_STEP.TEST_STEP_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).leftJoin((TableLike)Tables.REMOTE_AUTOMATION_REQUEST_EXTENDER).on(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.eq((Field)Tables.REMOTE_AUTOMATION_REQUEST_EXTENDER.AUTOMATION_REQUEST_ID)).asTable();
    }

    private Field<String> getResolvedKeywordType() {
        return DSL.choose().when(this.isDirectKeyword(), (Field)Tables.KEYWORD_TEST_STEP.KEYWORD).when(this.isConnectingKeyword(), this.getInheritedKeywordType()).otherwise((Object)UNDEFINED);
    }

    private Condition isDirectKeyword() {
        return Tables.KEYWORD_TEST_STEP.KEYWORD.in((Object[])new String[]{GIVEN, WHEN, THEN});
    }

    private Condition isConnectingKeyword() {
        return Tables.KEYWORD_TEST_STEP.KEYWORD.in((Object[])new String[]{AND, BUT});
    }

    private Field<String> getInheritedKeywordType() {
        return DSL.coalesce((Field)DSL.select((SelectField)Tables.KEYWORD_TEST_STEP.as((String)PREVIOUS_KEYWORD_STEP).KEYWORD).from((TableLike)Tables.TEST_CASE_STEPS.as(PREVIOUS_STEP)).join((TableLike)Tables.KEYWORD_TEST_STEP.as(PREVIOUS_KEYWORD_STEP)).on(Tables.TEST_CASE_STEPS.as((String)PREVIOUS_STEP).STEP_ID.eq((Field)Tables.KEYWORD_TEST_STEP.as((String)PREVIOUS_KEYWORD_STEP).TEST_STEP_ID)).where(this.getPreviousStepConditions()).orderBy((OrderField)Tables.TEST_CASE_STEPS.as((String)PREVIOUS_STEP).STEP_ORDER.desc()).limit((Number)1).asField(), (Object)UNDEFINED);
    }

    private Condition getPreviousStepConditions() {
        return Tables.TEST_CASE_STEPS.as((String)PREVIOUS_STEP).TEST_CASE_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID).and(Tables.TEST_CASE_STEPS.as((String)PREVIOUS_STEP).STEP_ORDER.lt((Field)Tables.TEST_CASE_STEPS.STEP_ORDER)).and(Tables.KEYWORD_TEST_STEP.as((String)PREVIOUS_KEYWORD_STEP).KEYWORD.notIn((Object[])new String[]{AND, BUT}));
    }

    private Field<?> getAutomationStatus() {
        return DSL.ifnull((Field)Tables.REMOTE_AUTOMATION_REQUEST_EXTENDER.REMOTE_STATUS, (Field)Tables.AUTOMATION_REQUEST.REQUEST_STATUS);
    }

    protected Field<?> getIdentifier() {
        return DSL.field((String)"ID");
    }

    protected Field<?> getProjectIdentifier() {
        return null;
    }

    protected SortField<?> getDefaultOrder() {
        return DSL.upper((String)"PROJECT_NAME").asc();
    }

    protected Condition craftInvariantFilter() {
        return Tables.KEYWORD_TEST_STEP.ACTION_WORD_ID.eq((Object)this.actionWordId);
    }
}

