/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapFieldValue;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TuleapField {
    public static final String PERMISSION_TYPE = "perm";
    public static final String ARTIFACT_LINK_TYPE = "art_link";
    public static final String CREATE_PERMISSION = "create";
    @JsonProperty(value="field_id")
    private Long id;
    @JsonProperty
    private String label;
    @JsonProperty
    private String name;
    @JsonProperty
    private String type;
    @JsonProperty
    private boolean required;
    @JsonProperty
    private List<String> permissions = new ArrayList<String>();
    @JsonProperty
    private List<TuleapFieldValue> values = new ArrayList<TuleapFieldValue>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public List<String> getEditPermissions() {
        return this.getPermissions().stream().filter(s -> !s.equals("read")).collect(Collectors.toList());
    }

    public boolean isEditable() {
        return !this.getEditPermissions().isEmpty();
    }

    public boolean canSubmit() {
        return this.getEditPermissions().contains(CREATE_PERMISSION);
    }

    public List<TuleapFieldValue> getValues() {
        return this.values;
    }

    public List<TuleapFieldValue> getVisibleValues() {
        if (Objects.isNull(this.values)) {
            return new ArrayList<TuleapFieldValue>();
        }
        return this.values.stream().filter(Objects::nonNull).filter(TuleapFieldValue::isVisible).collect(Collectors.toList());
    }

    public void setValues(List<TuleapFieldValue> values) {
        this.values = values;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("TuleapField{");
        sb.append("id=").append(this.id);
        sb.append(", label='").append(this.label).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", type='").append(this.type).append('\'');
        sb.append(", required=").append(this.required);
        sb.append(", permissions=").append(this.permissions);
        sb.append(", values=").append(this.values);
        sb.append('}');
        return sb.toString();
    }

    public boolean isAllowed() {
        boolean isPermissionType = Objects.equals(this.type, PERMISSION_TYPE);
        boolean isLinkType = Objects.equals(this.type, ARTIFACT_LINK_TYPE);
        return !isPermissionType && !isLinkType;
    }

    public boolean shouldHaveEmptyValue() {
        boolean isListType = Objects.equals(this.type, "sb");
        return !this.isRequired() && isListType;
    }
}

