/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.tuleap;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.TuleapConnector;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnector;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnectorProvider;

@Service(value="squashtest.core.bugtracker.TuleapConnectorProvider")
public class TuleapRestConnectorProvider
implements AdvancedBugTrackerConnectorProvider {
    private static final String KIND = "tuleap";
    private static final String LABEL = "Tuleap REST connector";
    @Inject
    private Provider<TuleapConnector> connectorProvider;

    public String getBugTrackerKind() {
        return KIND;
    }

    public String getLabel() {
        return LABEL;
    }

    public AdvancedBugTrackerConnector createConnector(BugTracker bugTracker) {
        if (bugTracker == null) {
            throw new NullArgumentException("bugTracker");
        }
        TuleapConnector connector = (TuleapConnector)this.connectorProvider.get();
        connector.setBugTracker(bugTracker);
        return connector;
    }
}

