/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.tuleap;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.squashtest.csp.core.bugtracker.core.NamespacedBugtrackerMessageSource;
import org.squashtest.tm.api.config.SquashPathProperties;
import org.squashtest.tm.plugin.bugtracker.tuleap.licensevalidator.LicenseValidator;
import org.squashtest.tm.plugin.bugtracker.tuleap.licensevalidator.service.ValidationService;
import org.squashtest.tm.plugin.bugtracker.tuleap.licensevalidator.service.impl.ValidationServiceImpl;

@Configuration
@ComponentScan(basePackages={"org.squashtest.tm.plugin.bugtracker.tuleap"})
public class TuleapRestConnectorConfig {
    @Inject
    private SquashPathProperties squashPathProperties;

    @Bean
    public MessageSource tuleapConnectorMessageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setCacheSeconds(60);
        messageSource.setBasenames(new String[]{"classpath:/org/squashtest/tm/plugin/bugtracker/tuleap/messages", this.squashPathProperties.getLanguagesPath() + "/plugin.bugtracker.tuleap/messages", this.squashPathProperties.getLanguagesPath() + "/henix-tm-tuleap-connector/tuleap"});
        return new NamespacedBugtrackerMessageSource((MessageSource)messageSource, "bugtracker.tuleap.");
    }

    @Bean(name={"org.squashtest.tm.plugin.bugtracker.tuleap.ValidationService"})
    public ValidationService validationService() {
        return new ValidationServiceImpl();
    }

    @Bean(name={"org.squashtest.tm.plugin.bugtracker.tuleap.LicenseValidator"})
    public LicenseValidator licenseValidator(@Named(value="org.squashtest.tm.plugin.bugtracker.tuleap.ValidationService") ValidationService service) {
        return new LicenseValidator(service);
    }
}

