#
#     This file is part of 'redmine-ext-api' plugin for Redmine.
#     Copyright (C) 2014 Henix, henix.fr
#
#     See the NOTICE file distributed with this work for additional
#     information regarding copyright ownership.
#
#     This is free software: you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation, either version 3 of the License, or
#     (at your option) any later version.
#
#     this software is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with this software.  If not, see <http://www.gnu.org/licenses/>.
#

class ExtendedWorkflowsController < ApplicationController

  NEW_ISSUE_STATUS_ID = 1

  accept_api_auth :index

  def index
    respond_to do |format|
      format.api {

        role_id_filter = params[:role_id].to_i
        permissions = ::WorkflowPermission
                .where(old_status_id: NEW_ISSUE_STATUS_ID)
                .where(role_id: role_id_filter)
                .to_a

        tracker_map = ::Tracker.pluck(:id, :name).to_h

        cf_ids = permissions.map(&:field_name).compact.uniq

        custom_field_map = ::CustomField.where(id: cf_ids).pluck(:id, :name).to_h

        @grouped_workflows = permissions.group_by(&:tracker_id).map do |tracker_id, perms|
          {
            tracker_name: tracker_map[tracker_id],

            permissions: perms.map do |p|
              {
                field_name: custom_field_map[p.field_name.to_i] || p.field_name,
                rule: p.rule
              }
            end
          }
        end
      }
    end
  end
end