/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.converter;

import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.IssuePriority;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.User;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedProject;
import org.squashtest.tm.bugtracker.advanceddomain.Field;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.advanceddomain.InputType;
import org.squashtest.tm.bugtracker.advanceddomain.Rendering;
import org.squashtest.tm.plugin.bugtracker.redmine3.converter.EntityMapping;
import org.squashtest.tm.plugin.bugtracker.redmine3.converter.Redmine3WidgetMapping;
import org.squashtest.tm.plugin.bugtracker.redmine3.converter.SquashIssueFiller;
import org.squashtest.tm.plugin.bugtracker.redmine3.domain.Redmine3FieldInfo;
import org.squashtest.tm.plugin.bugtracker.redmine3.domain.Redmine3FieldSchema;
import org.squashtest.tm.plugin.bugtracker.redmine3.domain.Redmine3StandardOperation;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedProject;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedTracker;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.converter.FieldNameTranslator;

@Component
public class Redmine3ToSquashEntityConverter {
    private static final Set<String> NUMERIC_TYPES = Set.of("redmine.custom.float", "redmine.custom.int", "estimated_hours");
    private static final String ISSUETYPE_FIELD_ID = "Tracker";
    private static final String PROJECTS_FIELD_ID = "project";
    @Inject
    private Redmine3WidgetMapping widgetMapping;
    @Inject
    private EntityMapping entityMapping;
    @Inject
    private FieldNameTranslator translator;

    public AdvancedProject redmine2SquashProject(Project redmineProject) {
        AdvancedProject squashProject = new AdvancedProject();
        this.widgetMapping.getProjectKeyHolder().set(redmineProject.getIdentifier());
        squashProject.setId(redmineProject.getIdentifier());
        squashProject.setName(redmineProject.getName());
        List<ExtendedTracker> issueTypes = ((ExtendedProject)redmineProject).getExtendedTrackers();
        Map<String, List<Field>> schemes = this.buildSchemeMap(issueTypes, redmineProject);
        squashProject.setSchemeMap(schemes);
        return squashProject;
    }

    public AdvancedIssue redmine2squashIssue(Issue redmineIssue) {
        AdvancedIssue squashIssue = new AdvancedIssue();
        SquashIssueFiller.fillSquashIssue(squashIssue, redmineIssue, ISSUETYPE_FIELD_ID);
        return squashIssue;
    }

    public List<AdvancedIssue> redmine2SquashIssues(Iterable<Issue> issueList) {
        ArrayList<AdvancedIssue> issues = new ArrayList<AdvancedIssue>();
        for (Issue redmineIssue : issueList) {
            AdvancedIssue squashIssue = new AdvancedIssue();
            SquashIssueFiller.fillSquashIssue(squashIssue, redmineIssue, ISSUETYPE_FIELD_ID);
            issues.add(squashIssue);
        }
        return issues;
    }

    public AdvancedProject createReadOnlyProjectStub(String schemeName, BugTrackerInterfaceDescriptor descriptor) {
        Field summaryField = this.createReadOnlyField("summary", descriptor.getReportSummaryLabel());
        Field descriptionField = this.createReadOnlyField("description", descriptor.getReportDescriptionLabel());
        descriptionField.getRendering().getInputType().setName(InputType.TypeName.TEXT_AREA.value);
        Field statusField = this.createReadOnlyField("status", descriptor.getTableStatusHeader());
        Field assigneeField = this.createReadOnlyField("assignee", descriptor.getReportAssigneeLabel());
        Field priorityField = this.createReadOnlyField("priority", descriptor.getReportPriorityLabel());
        AdvancedProject project = new AdvancedProject();
        project.setSchemeMap(Collections.singletonMap(schemeName, Arrays.asList(summaryField, priorityField, statusField, assigneeField, descriptionField)));
        return project;
    }

    public FieldValue convertToUserCompositeFieldValue(Iterable<User> users) {
        FieldValue newValue = new FieldValue();
        ArrayList<FieldValue> resultUsers = new ArrayList<FieldValue>();
        for (User user : users) {
            FieldValue uValue = new FieldValue(user.getFullName(), user.getFullName());
            uValue.setTypename("user");
            resultUsers.add(uValue);
        }
        newValue.setComposite(resultUsers.toArray(new FieldValue[resultUsers.size()]));
        return newValue;
    }

    private void buildSchemeForIssueType(ExtendedTracker issueType, Project redmineProject, Map<String, List<Field>> schemes, Field issueTypeField, List<FieldValue> possibleIssueTypes) {
        Map<String, Redmine3FieldInfo> fields = issueType.getFields(redmineProject);
        String schemeKey = "Tracker:" + issueType.getName();
        schemes.putIfAbsent(schemeKey, new ArrayList());
        schemes.get(schemeKey).add(issueTypeField);
        for (Map.Entry<String, Redmine3FieldInfo> entry : fields.entrySet()) {
            Redmine3FieldInfo fieldInfo = entry.getValue();
            String key = entry.getKey();
            if (key.equals(PROJECTS_FIELD_ID)) continue;
            if (key.equals(ISSUETYPE_FIELD_ID)) {
                issueTypeField.setLabel(fieldInfo.getName());
                FieldValue newIssueType = new FieldValue(issueType.getId().toString(), issueType.getName());
                possibleIssueTypes.add(newIssueType);
                continue;
            }
            Field squashField = this.redmineField2SquashField(fieldInfo, redmineProject);
            if (squashField == null) continue;
            schemes.get(schemeKey).add(squashField);
        }
    }

    private Map<String, List<Field>> buildSchemeMap(List<ExtendedTracker> issueTypes, Project redmineProject) {
        HashMap<String, List<Field>> schemes = new HashMap<String, List<Field>>();
        Field issueTypeField = this.createEmptyIssueTypeField();
        ArrayList<FieldValue> possibleIssueTypes = new ArrayList<FieldValue>();
        for (ExtendedTracker issueType : issueTypes) {
            this.buildSchemeForIssueType(issueType, redmineProject, schemes, issueTypeField, possibleIssueTypes);
        }
        issueTypeField.setPossibleValues(possibleIssueTypes.toArray(new FieldValue[possibleIssueTypes.size()]));
        return schemes;
    }

    private Field redmineField2SquashField(Redmine3FieldInfo fieldInfo, Project redmineProject) {
        if (this.entityMapping.shouldDismissField(fieldInfo)) {
            return null;
        }
        Field field = new Field();
        field.setId(fieldInfo.getId());
        String fieldName = fieldInfo.getName();
        if (!fieldInfo.getSchema().isCustom()) {
            fieldName = this.translator.translate(fieldName);
        }
        field.setLabel(fieldName);
        List<FieldValue> possibleValues = this.entityMapping.createFieldValues(fieldInfo, redmineProject);
        field.setPossibleValues(possibleValues.toArray(new FieldValue[possibleValues.size()]));
        String defaultValue = fieldInfo.getDefaultValue();
        defaultValue = StreamSupport.stream(((Iterable)Objects.requireNonNullElse(fieldInfo.getAllowedValues(), Collections.emptyList())).spliterator(), false).filter(IssuePriority.class::isInstance).map(IssuePriority.class::cast).filter(IssuePriority::isDefault).map(IssuePriority::getName).findFirst().orElse(defaultValue);
        field.setDefaultValue(defaultValue);
        field.setRendering(this.redmine2SquashRendering(fieldInfo));
        return field;
    }

    private Rendering redmine2SquashRendering(Redmine3FieldInfo fieldInfo) {
        Rendering rendering = new Rendering();
        ArrayList<String> operations = new ArrayList<String>();
        if (fieldInfo.getOperations() != null) {
            for (Redmine3StandardOperation operation : fieldInfo.getOperations()) {
                operations.add(operation.name());
            }
        }
        rendering.setOperations(operations.toArray(new String[operations.size()]));
        rendering.setInputType(this.redmine2SquashInputType(fieldInfo.getSchema()));
        rendering.setRequired(fieldInfo.isRequired());
        return rendering;
    }

    private InputType redmine2SquashInputType(Redmine3FieldSchema schema) {
        InputType inputType = new InputType();
        String originalName = schema.isCustom() ? schema.getCustom() : schema.getSystem();
        inputType.setOriginal(originalName);
        String squashName = this.widgetMapping.getCorrespondingSquashWidget(originalName);
        inputType.setName(squashName);
        Map<String, String> params = this.widgetMapping.getAdditionalParams(inputType);
        inputType.setConfiguration(params);
        String type = this.computeDataType(schema, squashName);
        inputType.setDataType(type);
        return inputType;
    }

    private String computeDataType(Redmine3FieldSchema schema, String squashName) {
        String type = schema.getType();
        if ("array".equals(type)) {
            return schema.getItems() + "-" + type;
        }
        if ("string-array".equals(type)) {
            return squashName;
        }
        if (type != null && NUMERIC_TYPES.contains(type)) {
            return "number";
        }
        return type;
    }

    private Field createEmptyIssueTypeField() {
        Field issueTypeField = new Field();
        issueTypeField.setId(ISSUETYPE_FIELD_ID);
        InputType inputType = new InputType(InputType.TypeName.DROPDOWN_LIST.value, ISSUETYPE_FIELD_ID);
        inputType.setFieldSchemeSelector(true);
        Rendering rendering = new Rendering(new String[]{"SET"}, inputType, true);
        issueTypeField.setRendering(rendering);
        return issueTypeField;
    }

    private Field createReadOnlyField(String id, String label) {
        Field field = new Field(id, label);
        Rendering rendering = new Rendering(new String[0], new InputType(InputType.TypeName.TEXT_FIELD.value, "unknown"), false);
        field.setRendering(rendering);
        return field;
    }
}

