/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.plugin.bugtracker.redmine3.Redmine3Client;
import org.squashtest.tm.plugin.bugtracker.redmine3.Redmine3ClientFactory;
import org.squashtest.tm.plugin.bugtracker.redmine3.utils.BaseCommunicatorFactory;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.StoredCredentialsManager;

@Component
public final class RedmineClientInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedmineClientInitializer.class);
    private final StoredCredentialsManager storedCredentialsManager;
    private final Redmine3ClientFactory redmine3ClientFactory;
    private final BaseCommunicatorFactory baseCommunicatorFactory;

    public RedmineClientInitializer(StoredCredentialsManager storedCredentialsManager, Redmine3ClientFactory redmine3ClientFactory, BaseCommunicatorFactory baseCommunicatorFactory) {
        this.storedCredentialsManager = storedCredentialsManager;
        this.redmine3ClientFactory = redmine3ClientFactory;
        this.baseCommunicatorFactory = baseCommunicatorFactory;
    }

    public Redmine3Client initRedmineClient(BugTracker bugTracker) {
        Credentials credentials = this.findCredentials(bugTracker);
        if (credentials == null) {
            LOGGER.warn("No credentials found for bugtracker {}. Cache cannot be used", (Object)bugTracker);
            return null;
        }
        Redmine3Client client = this.redmine3ClientFactory.create();
        client.init(bugTracker, credentials, this.baseCommunicatorFactory);
        return client;
    }

    private Credentials findCredentials(BugTracker bugTracker) {
        ManageableCredentials manageableCredentials = this.storedCredentialsManager.findReportingCacheCredentials(bugTracker.getId().longValue());
        if (manageableCredentials == null) {
            return null;
        }
        return manageableCredentials.build(this.storedCredentialsManager, (ThirdPartyServer)bugTracker, null);
    }
}

