/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.cookie;

import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.Contract;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.ThreadingBehavior;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.CommonCookieAttributeHandler;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.Cookie;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.CookieOrigin;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.MalformedCookieException;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.SetCookie;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.cookie.AbstractCookieAttributeHandler;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

