/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.cookie;

import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.Contract;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.ThreadingBehavior;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.conn.util.PublicSuffixMatcher;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.Cookie;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.CookieOrigin;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.CookieSpec;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.CookieSpecProvider;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.MalformedCookieException;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.cookie.BasicDomainHandler;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.cookie.BasicExpiresHandler;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.cookie.BasicMaxAgeHandler;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.cookie.BasicPathHandler;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.cookie.BasicSecureHandler;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.cookie.LaxExpiresHandler;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.cookie.LaxMaxAgeHandler;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.cookie.PublicSuffixDomainFilter;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.cookie.RFC6265LaxSpec;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.cookie.RFC6265StrictSpec;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class RFC6265CookieSpecProvider
implements CookieSpecProvider {
    private final CompatibilityLevel compatibilityLevel;
    private final PublicSuffixMatcher publicSuffixMatcher;
    private volatile CookieSpec cookieSpec;

    public RFC6265CookieSpecProvider(CompatibilityLevel compatibilityLevel, PublicSuffixMatcher publicSuffixMatcher) {
        this.compatibilityLevel = compatibilityLevel != null ? compatibilityLevel : CompatibilityLevel.RELAXED;
        this.publicSuffixMatcher = publicSuffixMatcher;
    }

    public RFC6265CookieSpecProvider(PublicSuffixMatcher publicSuffixMatcher) {
        this(CompatibilityLevel.RELAXED, publicSuffixMatcher);
    }

    public RFC6265CookieSpecProvider() {
        this(CompatibilityLevel.RELAXED, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CookieSpec create(HttpContext context) {
        if (this.cookieSpec == null) {
            RFC6265CookieSpecProvider rFC6265CookieSpecProvider = this;
            synchronized (rFC6265CookieSpecProvider) {
                if (this.cookieSpec == null) {
                    switch (this.compatibilityLevel) {
                        case STRICT: {
                            this.cookieSpec = new RFC6265StrictSpec(new BasicPathHandler(), PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicExpiresHandler(RFC6265StrictSpec.DATE_PATTERNS));
                            break;
                        }
                        case IE_MEDIUM_SECURITY: {
                            this.cookieSpec = new RFC6265LaxSpec(new BasicPathHandler(){

                                @Override
                                public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                                }
                            }, PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicExpiresHandler(RFC6265StrictSpec.DATE_PATTERNS));
                            break;
                        }
                        default: {
                            this.cookieSpec = new RFC6265LaxSpec(new BasicPathHandler(), PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new LaxMaxAgeHandler(), new BasicSecureHandler(), new LaxExpiresHandler());
                        }
                    }
                }
            }
        }
        return this.cookieSpec;
    }

    public static enum CompatibilityLevel {
        STRICT,
        RELAXED,
        IE_MEDIUM_SECURITY;

    }
}

