/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.converter;

import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.squashtest.tm.bugtracker.advanceddomain.CommonConfigurationKey;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.InputType;
import org.squashtest.tm.plugin.bugtracker.redmine3.command.DelegateCommands;

@Component
public class Redmine3WidgetMapping {
    private final ThreadLocal<String> projectKeyHolder = new ThreadLocal();
    private static final Map<String, String> WIDGET_MAP = new HashMap<String, String>();
    private static final Map<String, Map<String, String>> ADDITIONAL_PARAMS = new HashMap<String, Map<String, String>>();

    static {
        WIDGET_MAP.put("subject", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("description", InputType.TypeName.TEXT_AREA.value);
        WIDGET_MAP.put("status", InputType.TypeName.DROPDOWN_LIST.value);
        WIDGET_MAP.put("priority", InputType.TypeName.DROPDOWN_LIST.value);
        WIDGET_MAP.put("assigned_to_id", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("parent_issue_id", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("estimated_hours", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("done_ratio", InputType.TypeName.DROPDOWN_LIST.value);
        WIDGET_MAP.put("fixed_version_id", InputType.TypeName.DROPDOWN_LIST.value);
        WIDGET_MAP.put("category_id", InputType.TypeName.DROPDOWN_LIST.value);
        WIDGET_MAP.put("start_date", InputType.TypeName.DATE_PICKER.value);
        WIDGET_MAP.put("due_date", InputType.TypeName.DATE_PICKER.value);
        WIDGET_MAP.put("attachment", InputType.TypeName.FILE_UPLOAD.value);
        WIDGET_MAP.put("redmine.custom.list", InputType.TypeName.DROPDOWN_LIST.value);
        WIDGET_MAP.put("redmine.custom.string", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("redmine.custom.int", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("redmine.custom.user", InputType.TypeName.DROPDOWN_LIST.value);
        WIDGET_MAP.put("redmine.custom.version", InputType.TypeName.DROPDOWN_LIST.value);
        WIDGET_MAP.put("redmine.custom.date", InputType.TypeName.DATE_PICKER.value);
        WIDGET_MAP.put("redmine.custom.float", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("redmine.custom.text", InputType.TypeName.TEXT_AREA.value);
        WIDGET_MAP.put("redmine.custom.link", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("redmine.custom.bool", InputType.TypeName.DROPDOWN_LIST.value);
        WIDGET_MAP.put("redmine.custom.multiple", InputType.TypeName.MULTI_SELECT.value);
        HashMap datepickerformat = new HashMap(1);
        ADDITIONAL_PARAMS.put(InputType.TypeName.DATE_PICKER.value, datepickerformat);
    }

    public ThreadLocal<String> getProjectKeyHolder() {
        return this.projectKeyHolder;
    }

    public String getCorrespondingSquashWidget(String redmineName) {
        String widgetName = WIDGET_MAP.get(redmineName);
        return widgetName != null ? widgetName : InputType.TypeName.UNKNOWN.value;
    }

    public Map<String, String> getAdditionalParams(InputType inputType) {
        HashMap<String, String> finalParams = new HashMap<String, String>();
        Map<String, String> params = ADDITIONAL_PARAMS.get(inputType.getName());
        if (params != null) {
            finalParams.putAll(params);
        }
        if ((params = ADDITIONAL_PARAMS.get(inputType.getOriginal())) != null) {
            finalParams.putAll(params);
        }
        if ((params = this.getSpecialParams(inputType.getOriginal())) != null) {
            finalParams.putAll(params);
        }
        return finalParams;
    }

    private Map<String, String> getSpecialParams(String name) {
        HashMap<String, String> toReturn = null;
        String projectKey = this.projectKeyHolder.get();
        if ("assigned_to_id".equals(name)) {
            toReturn = new HashMap<String, String>(1);
            DelegateCommand searchCommand = DelegateCommands.buildSearchAssignableCommand(projectKey);
            toReturn.put(CommonConfigurationKey.ONCHANGE.value, searchCommand.getCommand());
        } else if ("reporter".equals(name)) {
            toReturn = new HashMap(1);
            DelegateCommand searchCommand = DelegateCommands.buildSearchReporterCommand(projectKey);
            toReturn.put(CommonConfigurationKey.ONCHANGE.value, searchCommand.getCommand());
        }
        return toReturn;
    }
}

