/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.cookie;

import java.util.Date;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.Contract;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.ThreadingBehavior;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.CommonCookieAttributeHandler;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.MalformedCookieException;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.SetCookie;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.cookie.AbstractCookieAttributeHandler;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicMaxAgeHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        int age;
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'max-age' attribute");
        }
        try {
            age = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid 'max-age' attribute: " + value);
        }
        if (age < 0) {
            throw new MalformedCookieException("Negative 'max-age' attribute: " + value);
        }
        cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)age * 1000L));
    }

    @Override
    public String getAttributeName() {
        return "max-age";
    }
}

