/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.converter;

import com.taskadapter.redmineapi.bean.Attachment;
import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.IssuePriority;
import com.taskadapter.redmineapi.bean.IssueStatus;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Role;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.bean.Version;
import com.taskadapter.redmineapi.bean.Watcher;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.plugin.bugtracker.redmine3.converter.EntityType;
import org.squashtest.tm.plugin.bugtracker.redmine3.json.JSONObject;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.converter.FieldNameTranslator;

@Component(value="redmine3FieldValueCreator")
@Scope(value="singleton")
public final class FieldValueCreator {
    @Inject
    private FieldNameTranslator translator;

    public FieldValue createFieldValue(String itemType, Object aValue) {
        FieldValue newValue = new FieldValue();
        if (itemType != null) {
            EntityType type = EntityType.fromString(itemType);
            newValue = switch (type) {
                case EntityType.PRIORITY, EntityType.PRIORITY_ID -> this.castAsBasicPriority(aValue);
                case EntityType.PROJECT -> this.castAsBasicProject(aValue);
                case EntityType.VERSION, EntityType.CUSTOM_VERSION -> this.castAsBasicVersion(aValue);
                case EntityType.USER, EntityType.CUSTOM_USER -> this.castAsBasicUser(aValue);
                case EntityType.PROJECTROLE -> this.castAsBasicProjectRole(aValue);
                case EntityType.STATUS -> this.castAsBasicStatus(aValue);
                case EntityType.WATCHERS -> this.castAsBasicWatchers(aValue);
                case EntityType.ATTACHMENT -> this.castAsAttachment(aValue);
                case EntityType.ISSUETYPE -> this.castAsBasicIssueType(aValue);
                case EntityType.JSONOBJECT -> this.castAsJSONObject(aValue);
                case EntityType.CUSTOM_FIELD -> this.castAsCustomFieldOption(aValue);
                case EntityType.DONE_RATIO -> this.castAsDoneRatio(aValue);
                case EntityType.CATEGORY -> this.castAsBasicCategory(aValue);
                case EntityType.CUSTOM_LIST -> this.castAsListItem(aValue);
                case EntityType.CUSTOM_BOOL -> this.castAsBool(aValue);
                default -> throw new NotImplementedException("Default case should not exist");
            };
            newValue.setTypename(itemType);
        }
        return newValue;
    }

    private FieldValue castAsBool(Object aValue) {
        return new FieldValue(aValue.toString(), this.translator.translate(aValue.toString()));
    }

    private FieldValue castAsListItem(Object aValue) {
        return new FieldValue(aValue.toString(), aValue.toString());
    }

    private FieldValue castAsDoneRatio(Object aValue) {
        return new FieldValue(aValue.toString(), aValue.toString());
    }

    private FieldValue castAsJSONObject(Object aValue) {
        FieldValue value = new FieldValue();
        JSONObject jsonObject = (JSONObject)aValue;
        Iterator<String> keys = jsonObject.keys();
        ArrayList<FieldValue> composite = new ArrayList<FieldValue>();
        while (keys.hasNext()) {
            String key = keys.next();
            composite.add(this.createFieldValue("", jsonObject.opt(key)));
        }
        value.setId("jsonObject");
        value.setComposite(composite.toArray(new FieldValue[composite.size()]));
        return value;
    }

    private FieldValue castAsBasicCategory(Object priority) {
        IssueCategory basicCategory = (IssueCategory)priority;
        String id = basicCategory.getId().toString();
        String name = basicCategory.getName();
        return new FieldValue(id, name);
    }

    private FieldValue castAsBasicPriority(Object priority) {
        IssuePriority basicPriority = (IssuePriority)priority;
        String id = basicPriority.getId().toString();
        String name = basicPriority.getName();
        return new FieldValue(id, name);
    }

    private FieldValue castAsBasicProject(Object project) {
        Project basicProject = (Project)project;
        String id = basicProject.getIdentifier();
        String name = basicProject.getName();
        return new FieldValue(id, name);
    }

    private FieldValue castAsBasicVersion(Object version) {
        Version basicVersion = (Version)version;
        String id = basicVersion.getId().toString();
        String name = basicVersion.getName();
        return new FieldValue(id, name);
    }

    private FieldValue castAsBasicUser(Object user) {
        User basicUser = (User)user;
        String id = basicUser.getId().toString();
        String name = basicUser.getFullName();
        return new FieldValue(id, name);
    }

    private FieldValue castAsBasicProjectRole(Object projectRole) {
        Role basicProjectRole = (Role)projectRole;
        String id = basicProjectRole.getName();
        String name = basicProjectRole.getName();
        return new FieldValue(id, name);
    }

    private FieldValue castAsBasicStatus(Object status) {
        IssueStatus basicStatus = (IssueStatus)status;
        String id = basicStatus.getName();
        String name = basicStatus.getName();
        return new FieldValue(id, name);
    }

    private FieldValue castAsBasicWatchers(Object watchers) {
        Watcher basicWatchers = (Watcher)watchers;
        String id = basicWatchers.getName();
        String name = basicWatchers.getName();
        return new FieldValue(id, name);
    }

    private FieldValue castAsAttachment(Object object) {
        FieldValue value = new FieldValue();
        Attachment attachment = (Attachment)object;
        FieldValue[] composite = new FieldValue[]{this.castAsBasicUser(attachment.getAuthor()), new FieldValue("contenturl", attachment.getContentURL().toString()), new FieldValue("creationdate", attachment.getCreatedOn().toString()), new FieldValue("filename", attachment.getFileName().toString()), new FieldValue("contenttype", attachment.getContentType().toString())};
        value.setId("attachment");
        value.setComposite(composite);
        return value;
    }

    private FieldValue castAsBasicIssueType(Object object) {
        FieldValue value = new FieldValue();
        Tracker issueType = (Tracker)object;
        value.setId("issuetype");
        value.setScalar(issueType.getName());
        return value;
    }

    private FieldValue castAsCustomFieldOption(Object object) {
        FieldValue value = new FieldValue();
        CustomField option = (CustomField)object;
        value.setId(Integer.toString(option.getId()));
        value.setScalar(option.getValue());
        return value;
    }
}

