/*
 * Decompiled with CFR 0.152.
 */
package jirarest.org.apache.http.impl.client.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import jirarest.org.apache.http.annotation.Contract;
import jirarest.org.apache.http.annotation.ThreadingBehavior;
import jirarest.org.apache.http.client.cache.HttpCacheEntry;
import jirarest.org.apache.http.client.cache.HttpCacheEntrySerializationException;
import jirarest.org.apache.http.client.cache.HttpCacheEntrySerializer;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultHttpCacheEntrySerializer
implements HttpCacheEntrySerializer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(HttpCacheEntry cacheEntry, OutputStream os) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(os);
        try {
            oos.writeObject(cacheEntry);
        }
        finally {
            oos.close();
        }
    }

    @Override
    public HttpCacheEntry readFrom(InputStream is) throws IOException {
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            HttpCacheEntry httpCacheEntry = (HttpCacheEntry)ois.readObject();
            return httpCacheEntry;
        }
        catch (ClassNotFoundException ex) {
            throw new HttpCacheEntrySerializationException("Class not found: " + ex.getMessage(), ex);
        }
        finally {
            ois.close();
        }
    }
}

