/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jirarest.com.atlassian.jira.rest.client.api.RestClientException;
import jirarest.com.atlassian.jira.rest.client.api.domain.BasicIssue;
import jirarest.com.atlassian.jira.rest.client.api.domain.Issue;
import jirarest.com.atlassian.jira.rest.client.api.domain.SearchResult;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.extension.ExtendedJiraRestClient;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.JiraRestClientOperation;

public class GetIssues
extends JiraRestClientOperation<List<Issue>> {
    private List<String> issueKeys;
    private static final int MAXRES = 50;
    private static final int STARTAT = 0;

    public GetIssues(ExtendedJiraRestClient client, List<String> issueKeys) {
        super(client);
        this.issueKeys = issueKeys;
    }

    @Override
    public List<Issue> doIt() {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        if (this.issueKeys.isEmpty()) {
            return issues;
        }
        String jql = "key in (" + StringUtils.join(this.issueKeys, (String)", ") + ")";
        SearchResult result = this.client.getSearchClient().searchJql(jql, 50, 0, null).claim();
        HashSet<String> issuesWithoutDuplicate = new HashSet<String>(this.issueKeys);
        if (Iterators.size(result.getIssues().iterator()) < issuesWithoutDuplicate.size()) {
            throw new RestClientException("Could not resolve issues with projects which have never existed in this JIRA instance", null);
        }
        for (BasicIssue basicIssue : result.getIssues()) {
            if (!Issue.class.isAssignableFrom(basicIssue.getClass())) continue;
            issues.add((Issue)basicIssue);
        }
        return issues;
    }
}

