/*
 * Decompiled with CFR 0.152.
 */
package jirarest.org.apache.http.protocol;

import java.io.IOException;
import jirarest.org.apache.http.HttpEntityEnclosingRequest;
import jirarest.org.apache.http.HttpException;
import jirarest.org.apache.http.HttpRequest;
import jirarest.org.apache.http.HttpRequestInterceptor;
import jirarest.org.apache.http.annotation.Contract;
import jirarest.org.apache.http.annotation.ThreadingBehavior;
import jirarest.org.apache.http.protocol.HttpContext;
import jirarest.org.apache.http.protocol.HttpDateGenerator;
import jirarest.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

