/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations;

import java.net.MalformedURLException;
import java.net.URL;
import jirarest.com.atlassian.jira.rest.client.api.domain.BasicIssue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.extension.ExtendedJiraRestClient;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.JiraRestClientOperation;

public class FindIssueURL
extends JiraRestClientOperation<URL> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FindIssueURL.class);
    private String issueKey;

    public FindIssueURL(ExtendedJiraRestClient client, String issueKey) {
        super(client);
        this.issueKey = issueKey;
    }

    @Override
    public URL doIt() {
        URL url = null;
        BasicIssue issue = this.client.getIssueClient().getIssue(this.issueKey).claim();
        try {
            url = issue.getSelf().toURL();
        }
        catch (MalformedURLException e) {
            LOGGER.debug("JIRA issue '{}' had a malformed URL", (Object)issue.getKey(), (Object)e);
        }
        return url;
    }
}

