/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jirarest.internal.exceptions;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jirarest.com.atlassian.jira.rest.client.api.RestClientException;
import jirarest.com.atlassian.jira.rest.client.api.domain.util.ErrorCollection;
import jirarest.com.sun.jersey.api.client.UniformInterfaceException;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.core.ProjectNotFoundException;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.exceptions.JiraProjectNotFound;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.exceptions.NumberConversionException;

@Component(value="jiraRestExceptionHandler")
public class ExceptionHandler {
    @Inject
    @Named(value="jiraRestConnectorMessageSource")
    private MessageSource messageSource;
    private static final Pattern USER_NOT_FOUND_PATTERN = Pattern.compile("User '(.*)' was not found in the system.");

    private Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }

    public BugTrackerRemoteException genericError(Exception ex) {
        String translation = this.messageSource.getMessage("exception.squash.unknownexception", null, this.getLocale());
        return new BugTrackerRemoteException(translation + ex.getMessage(), ex.getCause());
    }

    public BugTrackerRemoteException genericError(Exception ex, String specificMessage) {
        String translation = this.messageSource.getMessage("exception.squash.unknownexception", null, this.getLocale());
        return new BugTrackerRemoteException(translation + specificMessage, ex.getCause());
    }

    public ProjectNotFoundException projectNotFound(JiraProjectNotFound exception) {
        String projectIdentifier = exception.getProjectIdentifier();
        String translation = this.messageSource.getMessage("exception.squash.notfound.project", new Object[]{projectIdentifier}, this.getLocale());
        return new ProjectNotFoundException(translation, null);
    }

    public BugTrackerRemoteException numberConversionFailure(NumberConversionException exception) {
        String expression = exception.getValue();
        String translation = this.messageSource.getMessage("exception.squash.number.conversion", new Object[]{expression}, this.getLocale());
        return new ProjectNotFoundException(translation, null);
    }

    public BugTrackerRemoteException handleUniformException(UniformInterfaceException ex, String defaultMessage) {
        Integer statusCode = ex.getResponse().getClientResponseStatus().getStatusCode();
        return switch (statusCode) {
            case 401 -> {
                String message = this.messageSource.getMessage("exception.squash.accessdenied", null, this.getLocale());
                yield new BugTrackerNoCredentialsException(message, (Throwable)ex);
            }
            default -> this.genericError(ex, defaultMessage);
        };
    }

    public BugTrackerRemoteException handleRestException(RestClientException exception) {
        Throwable cause = exception.getCause();
        if (!UniformInterfaceException.class.isAssignableFrom(cause.getClass())) {
            if ((Integer)exception.getStatusCode().get() == 401) {
                String message = this.messageSource.getMessage("exception.squash.accessdenied", null, this.getLocale());
                return new BugTrackerNoCredentialsException(message, (Throwable)exception);
            }
            if ((Integer)exception.getStatusCode().get() == 404) {
                String notFoundMessage = this.messageSource.getMessage("exception.squash.notfound.issue", null, this.getLocale());
                String translation = this.messageSource.getMessage("exception.squash.unknownexception", null, this.getLocale());
                String errorMessage = String.format("%s %s", translation, notFoundMessage);
                return new BugTrackerRemoteException(errorMessage, (Throwable)exception);
            }
            return this.genericError(exception);
        }
        StringBuilder messageBuilder = this.createErrorMessageBuilder(exception);
        return this.handleUniformException((UniformInterfaceException)cause, messageBuilder.toString());
    }

    private StringBuilder createErrorMessageBuilder(RestClientException exception) {
        StringBuilder builder = new StringBuilder();
        for (ErrorCollection errorCollection : exception.getErrorCollections()) {
            for (String message : errorCollection.getErrorMessages()) {
                builder.append(this._translateNativeMessage(message) + " ");
            }
        }
        return builder;
    }

    private String _translateNativeMessage(String original) {
        String translation;
        if (original == null) {
            translation = null;
        } else {
            Matcher matcher = USER_NOT_FOUND_PATTERN.matcher(original);
            if (matcher.find()) {
                String username = matcher.group(1);
                translation = this.messageSource.getMessage("exception.squash.notfound.user", new Object[]{username}, this.getLocale());
            } else {
                translation = original.matches("Not a valid URL") ? this.messageSource.getMessage("exception.squash.invalidurl", null, this.getLocale()) : (original.matches("Option id .* is not valid") ? this.messageSource.getMessage("exception.squash.invalidoption", null, this.getLocale()) : (original.matches("Option value .* is not valid") ? this.messageSource.getMessage("exception.squash.invalidoption", null, this.getLocale()) : (original.matches("Impossible de modifier l'option .*") ? this.messageSource.getMessage("exception.squash.optionnone", null, this.getLocale()) : original)));
            }
        }
        return translation;
    }

    private static interface JiraMessage {
        public static final String INVALID_URL = "Not a valid URL";
        public static final String INVALID_OPTION_ID = "Option id .* is not valid";
        public static final String INVALID_OPTION_VALUE = "Option value .* is not valid";
        public static final String OPTION_NONE = "Impossible de modifier l'option .*";
    }

    private static interface SquashMessageKeys {
        public static final String UNKNOWN_EXCEPTION = "exception.squash.unknownexception";
        public static final String WRONG_CREDENTIALS = "exception.squash.accessdenied";
        public static final String ISSUE_NOT_FOUND = "exception.squash.notfound.issue";
        public static final String PROJECT_NOT_FOUND = "exception.squash.notfound.project";
        public static final String NUMBER_CONVERSION = "exception.squash.number.conversion";
        public static final String USER_NOT_FOUND = "exception.squash.notfound.user";
        public static final String INVALID_URL = "exception.squash.invalidurl";
        public static final String INVALID_OPTION = "exception.squash.invalidoption";
        public static final String OPTION_NONE = "exception.squash.optionnone";
    }
}

