/*
 * Decompiled with CFR 0.152.
 */
package jirarest.org.apache.http.nio.protocol;

import java.io.IOException;
import jirarest.org.apache.http.HttpException;
import jirarest.org.apache.http.HttpRequest;
import jirarest.org.apache.http.annotation.Contract;
import jirarest.org.apache.http.annotation.ThreadingBehavior;
import jirarest.org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import jirarest.org.apache.http.nio.protocol.HttpAsyncExchange;
import jirarest.org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import jirarest.org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import jirarest.org.apache.http.protocol.HttpContext;
import jirarest.org.apache.http.protocol.HttpRequestHandler;
import jirarest.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class BasicAsyncRequestHandler
implements HttpAsyncRequestHandler<HttpRequest> {
    private final HttpRequestHandler handler;

    public BasicAsyncRequestHandler(HttpRequestHandler handler) {
        Args.notNull(handler, "Request handler");
        this.handler = handler;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest request, HttpContext context) {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(HttpRequest request, HttpAsyncExchange httpexchange, HttpContext context) throws HttpException, IOException {
        this.handler.handle(request, httpexchange.getResponse(), context);
        httpexchange.submitResponse();
    }
}

