/*
 * Decompiled with CFR 0.152.
 */
package jirarest.com.atlassian.jira.rest.client.internal.async;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.Properties;
import jirarest.com.atlassian.event.api.EventPublisher;
import jirarest.com.atlassian.httpclient.apache.httpcomponents.DefaultHttpClientFactory;
import jirarest.com.atlassian.httpclient.api.HttpClient;
import jirarest.com.atlassian.httpclient.api.factory.HttpClientOptions;
import jirarest.com.atlassian.jira.rest.client.api.AuthenticationHandler;
import jirarest.com.atlassian.jira.rest.client.internal.async.AtlassianHttpClientDecorator;
import jirarest.com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;
import jirarest.com.atlassian.sal.api.ApplicationProperties;
import jirarest.com.atlassian.sal.api.UrlMode;
import jirarest.com.atlassian.sal.api.executor.ThreadLocalContextManager;
import jirarest.javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousHttpClientFactory {
    public DisposableHttpClient createClient(URI serverUri, AuthenticationHandler authenticationHandler) {
        HttpClientOptions options = new HttpClientOptions();
        final DefaultHttpClientFactory defaultHttpClientFactory = new DefaultHttpClientFactory(new NoOpEventPublisher(), new RestClientApplicationProperties(serverUri), new ThreadLocalContextManager(){

            public Object getThreadLocalContext() {
                return null;
            }

            public void setThreadLocalContext(Object context) {
            }

            @Override
            public void clearThreadLocalContext() {
            }
        });
        final HttpClient httpClient = defaultHttpClientFactory.create(options);
        return new AtlassianHttpClientDecorator(httpClient, authenticationHandler){

            @Override
            public void destroy() throws Exception {
                defaultHttpClientFactory.dispose(httpClient);
            }
        };
    }

    public DisposableHttpClient createClient(HttpClient client) {
        return new AtlassianHttpClientDecorator(client, null){

            @Override
            public void destroy() throws Exception {
            }
        };
    }

    private static final class MavenUtils {
        private static final Logger logger = LoggerFactory.getLogger(MavenUtils.class);
        private static final String UNKNOWN_VERSION = "unknown";

        private MavenUtils() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static String getVersion(String groupId, String artifactId) {
            Properties props = new Properties();
            InputStream resourceAsStream = null;
            try {
                resourceAsStream = MavenUtils.class.getResourceAsStream(String.format("/META-INF/maven/%s/%s/pom.properties", groupId, artifactId));
                props.load(resourceAsStream);
                String string = props.getProperty("version", UNKNOWN_VERSION);
                return string;
            }
            catch (Exception e) {
                logger.debug("Could not find version for maven artifact {}:{}", (Object)groupId, (Object)artifactId);
                logger.debug("Got the following exception", (Throwable)e);
                String string = UNKNOWN_VERSION;
                return string;
            }
            finally {
                if (resourceAsStream != null) {
                    try {
                        resourceAsStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static class RestClientApplicationProperties
    implements ApplicationProperties {
        private final String baseUrl;

        private RestClientApplicationProperties(URI jiraURI) {
            this.baseUrl = jiraURI.getPath();
        }

        @Override
        public String getBaseUrl() {
            return this.baseUrl;
        }

        @Override
        @Nonnull
        public String getBaseUrl(UrlMode urlMode) {
            return this.baseUrl;
        }

        @Override
        @Nonnull
        public String getDisplayName() {
            return "Atlassian JIRA Rest Java Client";
        }

        @Override
        @Nonnull
        public String getPlatformId() {
            return "jira";
        }

        @Override
        @Nonnull
        public String getVersion() {
            return MavenUtils.getVersion("jirarest.com.atlassian.jira", "jira-rest-java-client-core");
        }

        @Override
        @Nonnull
        public Date getBuildDate() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nonnull
        public String getBuildNumber() {
            return String.valueOf(0);
        }

        @Override
        public File getHomeDirectory() {
            return new File(".");
        }

        @Override
        public String getPropertyValue(String s) {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    private static class NoOpEventPublisher
    implements EventPublisher {
        private NoOpEventPublisher() {
        }

        @Override
        public void publish(Object o) {
        }

        @Override
        public void register(Object o) {
        }

        @Override
        public void unregister(Object o) {
        }

        @Override
        public void unregisterAll() {
        }
    }
}

