/*
 * Decompiled with CFR 0.152.
 */
package jirarest.org.apache.http.protocol;

import java.io.IOException;
import jirarest.org.apache.http.HttpException;
import jirarest.org.apache.http.HttpRequest;
import jirarest.org.apache.http.HttpRequestInterceptor;
import jirarest.org.apache.http.annotation.Contract;
import jirarest.org.apache.http.annotation.ThreadingBehavior;
import jirarest.org.apache.http.protocol.HttpContext;
import jirarest.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

