/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.org.codehaus.jackson.map.ser.std;

import java.io.IOException;
import java.util.Iterator;
import jiracloud.org.codehaus.jackson.JsonGenerationException;
import jiracloud.org.codehaus.jackson.JsonGenerator;
import jiracloud.org.codehaus.jackson.map.BeanProperty;
import jiracloud.org.codehaus.jackson.map.JsonSerializer;
import jiracloud.org.codehaus.jackson.map.SerializerProvider;
import jiracloud.org.codehaus.jackson.map.TypeSerializer;
import jiracloud.org.codehaus.jackson.map.annotate.JacksonStdImpl;
import jiracloud.org.codehaus.jackson.map.ser.std.AsArraySerializerBase;
import jiracloud.org.codehaus.jackson.map.ser.std.ContainerSerializerBase;
import jiracloud.org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class IterableSerializer
extends AsArraySerializerBase<Iterable<?>> {
    public IterableSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, BeanProperty property) {
        super(Iterable.class, elemType, staticTyping, vts, property, null);
    }

    @Override
    public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
        return new IterableSerializer(this._elementType, this._staticTyping, vts, this._property);
    }

    @Override
    public void serializeContents(Iterable<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        Iterator<?> it = value.iterator();
        if (it.hasNext()) {
            TypeSerializer typeSer = this._valueTypeSerializer;
            JsonSerializer<Object> prevSerializer = null;
            Class<?> prevClass = null;
            do {
                JsonSerializer<Object> currSerializer;
                Object elem;
                if ((elem = it.next()) == null) {
                    provider.defaultSerializeNull(jgen);
                    continue;
                }
                Class<?> cc = elem.getClass();
                if (cc == prevClass) {
                    currSerializer = prevSerializer;
                } else {
                    prevSerializer = currSerializer = provider.findValueSerializer(cc, this._property);
                    prevClass = cc;
                }
                if (typeSer == null) {
                    currSerializer.serialize(elem, jgen, provider);
                    continue;
                }
                currSerializer.serializeWithType(elem, jgen, provider, typeSer);
            } while (it.hasNext());
        }
    }
}

