/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.com.atlassian.jira.rest.client.internal.json;

import com.google.common.base.Splitter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import jiracloud.com.atlassian.jira.rest.client.api.OptionalIterable;
import jiracloud.com.atlassian.jira.rest.client.api.domain.BasicComponent;
import jiracloud.com.atlassian.jira.rest.client.api.domain.BasicProjectRole;
import jiracloud.com.atlassian.jira.rest.client.api.domain.BasicUser;
import jiracloud.com.atlassian.jira.rest.client.api.domain.IssueType;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Project;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Version;
import jiracloud.com.atlassian.jira.rest.client.internal.json.BasicComponentJsonParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.BasicProjectRoleJsonParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.IssueTypeJsonParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jiracloud.com.atlassian.jira.rest.client.internal.json.VersionJsonParser;
import jiracloud.org.codehaus.jettison.json.JSONArray;
import jiracloud.org.codehaus.jettison.json.JSONException;
import jiracloud.org.codehaus.jettison.json.JSONObject;

public class ProjectJsonParser
implements JsonObjectParser<Project> {
    private final VersionJsonParser versionJsonParser = new VersionJsonParser();
    private final BasicComponentJsonParser componentJsonParser = new BasicComponentJsonParser();
    private final IssueTypeJsonParser issueTypeJsonParser = new IssueTypeJsonParser();
    private final BasicProjectRoleJsonParser basicProjectRoleJsonParser = new BasicProjectRoleJsonParser();

    static Iterable<String> parseExpandos(JSONObject json) throws JSONException {
        if (json.has("expand")) {
            String expando = json.getString("expand");
            return Splitter.on((char)',').split((CharSequence)expando);
        }
        return Collections.emptyList();
    }

    @Override
    public Project parse(JSONObject json) throws JSONException {
        URI uri;
        URI self = JsonParseUtil.getSelfUri(json);
        Iterable<String> expandos = ProjectJsonParser.parseExpandos(json);
        BasicUser lead = JsonParseUtil.parseBasicUser(json.getJSONObject("lead"));
        String key = json.getString("key");
        Long id = JsonParseUtil.getOptionalLong(json, "id");
        String name = JsonParseUtil.getOptionalString(json, "name");
        String urlStr = JsonParseUtil.getOptionalString(json, "url");
        try {
            uri = urlStr == null || "".equals(urlStr) ? null : new URI(urlStr);
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        String description = JsonParseUtil.getOptionalString(json, "description");
        if ("".equals(description)) {
            description = null;
        }
        Collection<Version> versions = JsonParseUtil.parseJsonArray(json.getJSONArray("versions"), this.versionJsonParser);
        Collection<BasicComponent> components = JsonParseUtil.parseJsonArray(json.getJSONArray("components"), this.componentJsonParser);
        JSONArray issueTypesArray = json.optJSONArray("issueTypes");
        OptionalIterable<IssueType> issueTypes = JsonParseUtil.parseOptionalJsonArray(issueTypesArray, this.issueTypeJsonParser);
        Collection<BasicProjectRole> projectRoles = this.basicProjectRoleJsonParser.parse(JsonParseUtil.getOptionalJsonObject(json, "roles"));
        return new Project(expandos, self, key, id, name, description, lead, uri, versions, components, issueTypes, projectRoles);
    }
}

