/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jiracloud;

import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.lang.NullArgumentException;
import org.springframework.stereotype.Service;
import org.squashtest.csp.core.bugtracker.spi.DefaultOAuth2FormValues;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.JiraCloudConnector;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnector;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnectorProvider;
import org.squashtest.tm.service.spi.DefaultOAuth2ConfigurationHandler;
import org.squashtest.tm.service.spi.GenericServerOAuth2Conf;
import org.squashtest.tm.service.spi.OAuth2ConfigurationHandler;

@Service(value="squashtest.core.bugtracker.JiraCloudConnectorProvider")
public class JiraCloudConnectorProvider
implements AdvancedBugTrackerConnectorProvider {
    private static final String JIRA_CLOUD_OFFLINE_ACCESS_SCOPE = "offline_access";
    private static final String KIND = "jira.cloud";
    private static final String LABEL = "JIRA CLOUD connector";
    @Inject
    private Provider<JiraCloudConnector> connectorProvider;

    public String getBugTrackerKind() {
        return KIND;
    }

    public String getLabel() {
        return LABEL;
    }

    public AdvancedBugTrackerConnector createConnector(BugTracker bugTracker) {
        if (bugTracker == null) {
            throw new NullArgumentException("bugTracker");
        }
        JiraCloudConnector connector = (JiraCloudConnector)this.connectorProvider.get();
        connector.init();
        connector.setBugTracker(bugTracker);
        return connector;
    }

    public OAuth2ConfigurationHandler getOAuth2ConfigurationHandler() {
        return new DefaultOAuth2ConfigurationHandler(){

            public void appendScope(String bugTrackerUrl, StringBuilder sb, GenericServerOAuth2Conf conf) {
                sb.append("&scope=");
                sb.append(conf.getScope()).append(" ").append(JiraCloudConnectorProvider.JIRA_CLOUD_OFFLINE_ACCESS_SCOPE);
                sb.append("&audience=api.atlassian.com");
                sb.append("&prompt=consent");
            }

            public DefaultOAuth2FormValues getDefaultValueForOauth2Form(String bugTrackerUrl) {
                return new DefaultOAuth2FormValues("https://auth.atlassian.com/authorize", "https://auth.atlassian.com/oauth/token", "read:jira-user read:jira-work write:jira-work manage:jira-configuration manage:jira-project read:sprint:jira-software read:project:jira read:issue-details:jira read:board-scope:jira-software read:jql:jira read:board-scope.admin:jira-software");
            }
        };
    }
}

