/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jiracloud.com.atlassian.jira.rest.client.api.RestClientException;
import jiracloud.com.atlassian.jira.rest.client.api.domain.BasicIssue;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Issue;
import jiracloud.com.atlassian.jira.rest.client.api.domain.SearchResult;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.extension.ExtendedJiraRestClient;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.JiraRestClientOperation;

public class GetIssues
extends JiraRestClientOperation<List<Issue>> {
    private List<String> issueKeys;
    private static final int MAXRES = 50;

    public GetIssues(ExtendedJiraRestClient client, List<String> issueKeys) {
        super(client);
        this.issueKeys = issueKeys;
    }

    @Override
    public List<Issue> doIt() {
        SearchResult result;
        ArrayList<Issue> issues = new ArrayList<Issue>();
        if (this.issueKeys.isEmpty()) {
            return issues;
        }
        String jql = "key in (" + StringUtils.join(this.issueKeys, (String)", ") + ")";
        String nextPageToken = null;
        Set<String> essentialFields = Set.of("self", "key", "summary", "status", "assignee", "issuetype", "project", "created", "updated", "priority");
        do {
            result = this.client.getSearchClient().searchJqlCloud(jql, 50, nextPageToken, essentialFields).claim();
            for (BasicIssue basicIssue : result.getIssues()) {
                if (!Issue.class.isAssignableFrom(basicIssue.getClass())) continue;
                issues.add((Issue)basicIssue);
            }
        } while ((nextPageToken = result.getNextPageToken()) != null);
        HashSet<String> issuesWithoutDuplicate = new HashSet<String>(this.issueKeys);
        if (Iterators.size(issues.iterator()) < issuesWithoutDuplicate.size()) {
            throw new RestClientException("Could not resolve all issues.", null);
        }
        return issues;
    }
}

