/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jiracloud.internal.extension;

import java.net.URI;
import jiracloud.com.atlassian.httpclient.api.HttpClient;
import jiracloud.com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import jiracloud.com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClient;
import jiracloud.com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;
import jiracloud.com.atlassian.jira.rest.client.internal.json.JsonArrayParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jiracloud.com.sun.ws.rs.core.UriBuilder;
import jiracloud.io.atlassian.util.concurrent.Promise;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.extension.ExtendedJiraRestClient;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.extension.ExtensionClient;

public class ExtendedJiraRestClientImpl
extends AsynchronousJiraRestClient
implements ExtendedJiraRestClient {
    protected ExtensionClient extensionClient;

    public ExtendedJiraRestClientImpl(URI serverUri, DisposableHttpClient httpClient) {
        super(serverUri, httpClient);
        this.extensionClient = new AsynchronousExtensionClient(serverUri, httpClient);
    }

    @Override
    public ExtensionClient getExtensionClient() {
        return this.extensionClient;
    }

    private static class AsynchronousExtensionClient
    extends AbstractAsynchronousRestClient
    implements ExtensionClient {
        private URI baseUri;
        private URI sessionBaseUri;

        public AsynchronousExtensionClient(URI baseUri, HttpClient client) {
            super(client);
            this.baseUri = UriBuilder.fromUri(baseUri).path("/rest/api/latest").build(new Object[0]);
            this.sessionBaseUri = UriBuilder.fromUri(baseUri).path("/rest/auth/1").build(new Object[0]);
        }

        @Override
        public URI getBaseURI() {
            return this.baseUri;
        }

        @Override
        public URI getSessionBaseURI() {
            return this.sessionBaseUri;
        }

        @Override
        public <T> Promise<T> getAndParse(URI uri, JsonObjectParser<T> parser) {
            return super.getAndParse(uri, parser);
        }

        @Override
        public <T> Promise<T> getAndParse(URI uri, JsonArrayParser<T> parser) {
            return super.getAndParse(uri, parser);
        }
    }
}

