/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations;

import java.net.URI;
import java.util.Comparator;
import java.util.List;
import jiracloud.com.sun.ws.rs.core.UriBuilder;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.extension.ExtendedJiraRestClient;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.extension.ExtensionClient;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.json.BasicEntity;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.json.EpicLinkListJsonParser;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.JiraRestClientOperation;

public class SearchEpics
extends JiraRestClientOperation<Iterable<BasicEntity>> {
    private static final String JIRA_SEARCH_API_ENDPOINT = "/search/jql";
    private static final String JQL_QUERY_PARAM = "issuetype = Epic AND summary~";
    private final ExtendedJiraRestClient extClient;
    private String searchString;
    private final EpicLinkListJsonParser parser = new EpicLinkListJsonParser();

    public SearchEpics(ExtendedJiraRestClient client, String searchString) {
        super(client);
        this.extClient = client;
        this.searchString = searchString;
    }

    @Override
    public Iterable<BasicEntity> doIt() {
        ExtensionClient extension = this.extClient.getExtensionClient();
        URI baseURI = extension.getBaseURI();
        URI epicsURI = UriBuilder.fromUri(baseURI).path(JIRA_SEARCH_API_ENDPOINT).queryParam("jql", "issuetype = Epic AND summary~'" + this.searchString + "'").build(new Object[0]);
        List<BasicEntity> epics = extension.getAndParse(epicsURI, this.parser).claim();
        this.sortEpics(epics);
        return epics;
    }

    private void sortEpics(List<BasicEntity> epics) {
        epics.sort(Comparator.comparing(BasicEntity::getKey));
    }
}

