/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jiracloud.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import jiracloud.com.atlassian.httpclient.api.Request;
import jiracloud.com.atlassian.jira.rest.client.api.AuthenticationHandler;
import jiracloud.com.atlassian.jira.rest.client.api.RestClientException;
import jiracloud.com.atlassian.jira.rest.client.api.domain.BasicIssue;
import jiracloud.com.atlassian.jira.rest.client.api.domain.BasicUser;
import jiracloud.com.atlassian.jira.rest.client.api.domain.CimProject;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Issue;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Permissions;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Priority;
import jiracloud.com.atlassian.jira.rest.client.api.domain.input.AttachmentInput;
import jiracloud.com.atlassian.jira.rest.client.api.domain.input.CannotTransformValueException;
import jiracloud.com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import jiracloud.com.atlassian.jira.rest.client.api.domain.input.LinkIssuesInput;
import jiracloud.com.sun.jersey.api.client.UniformInterfaceException;
import jiracloud.com.sun.ws.rs.core.UriBuilder;
import jiracloud.org.apache.http.util.EncodingUtils;
import jiracloud.org.codehaus.jackson.JsonNode;
import jiracloud.org.codehaus.jackson.map.ObjectMapper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.OAuth2Credentials;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.JiraClient;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.JiraCloudBugTrackerInterfaceDescriptor;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.MovedIssue;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.StubIssue;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.exceptions.CloudExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.exceptions.JiraProjectNotFound;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.extension.CustomJiraClientFactory;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.extension.ExtendedJiraRestClient;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.json.BasicEntity;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.json.ServerInfo;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.json.SimpleSprint;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.CreateIssue;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.FindIssueURL;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.ForwardAttachments;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.GetIssue;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.GetIssues;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.GetMyself;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.GetPriorities;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.GetProjectForCreateById;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.GetProjectForCreateByKey;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.GetProjectKeyByName;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.GetReporter;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.GetServerInfo;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.GetUserPickerPermission;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.JiraRestClientOperation;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.LinkIssue;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.SearchAssignableUsers;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.SearchEpics;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.SearchEpicsWithGreenHopper;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.SearchSprints;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.SearchSprintsWithGreenHopper;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.SearchUsers;

@Component
@Scope(value="prototype")
public class JiraCloudClientImpl
implements JiraClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraCloudClientImpl.class);
    private static final String LOG_HEADER = "JIRA REST client : ";
    private static final String AN_ERROR_OCCURED = "an error occured during operation : ";
    private static final String HTTP_AUTHORIZATION = "Authorization";
    private static final String ATLASSIAN_TOKEN_ACCESSIBLE_RESOURCES_API_ENDPOINT = "https://api.atlassian.com/oauth/token/accessible-resources";
    private static final String ATLASSIAN_OAUTH2_REST_API_ENDPOINT_STARTER = "https://api.atlassian.com/ex/jira/";
    private static boolean disabledExtension = false;
    @Inject
    private CloudExceptionHandler exceptionHandler;
    @Inject
    @Named(value="jiraCloudConnectorMessageSource")
    private MessageSource messageSource;
    @Inject
    @Named(value="jiraCloudBugTrackerInterfaceDescriptor")
    private BugTrackerInterfaceDescriptor descriptor;
    private URI greenHopperURI;
    private String baseUrl;
    private ExtendedJiraRestClient client;
    private static BugTracker bugtracker;

    private Locale getLocale() {
        return ((JiraCloudBugTrackerInterfaceDescriptor)this.descriptor).getLocale();
    }

    @Override
    public void init(BugTracker bugTracker, Credentials credentials) {
        URI uri;
        bugtracker = bugTracker;
        LOGGER.debug("creating the jira client");
        if (bugTracker.getAuthenticationProtocol() == AuthenticationProtocol.OAUTH_2) {
            String cloudId = JiraCloudClientImpl.getCloudIdForOauth2ApiRequest((OAuth2Credentials)credentials);
            this.baseUrl = ATLASSIAN_OAUTH2_REST_API_ENDPOINT_STARTER + cloudId;
        } else {
            this.baseUrl = bugTracker.getUrl();
        }
        try {
            uri = new URI(this.baseUrl);
        }
        catch (URISyntaxException exception) {
            throw this.logAndThrowLocalException("JIRA REST client : url " + this.baseUrl + " is invalid", exception);
        }
        AuthenticationHandler authHandler = JiraCloudClientImpl.createAuthHandler(credentials);
        this.client = new CustomJiraClientFactory().create(uri, authHandler);
        String btUrl = bugTracker.getUrl().replaceAll("\\/*$", "");
        this.greenHopperURI = UriBuilder.fromUri(btUrl + "/rest/greenhopper/1.0").build(new Object[0]);
    }

    @Override
    public ServerInfo findServerInfo() {
        LOGGER.debug("fetching remote JIRA server info");
        GetServerInfo operation = new GetServerInfo(this.client);
        return this.doInCatchBlock(operation);
    }

    @Override
    public Iterable<Priority> getAllPriorities() {
        LOGGER.debug("fetching priorities");
        GetPriorities operation = new GetPriorities(this.client);
        return this.doInCatchBlock(operation);
    }

    @Override
    public String findProjectKeyByName(String projectName) {
        LOGGER.debug("fetching project named '{}'", (Object)projectName);
        GetProjectKeyByName operation = new GetProjectKeyByName(this.client, projectName);
        return this.doInCatchBlock(operation);
    }

    @Override
    public String getReporter() {
        LOGGER.debug("fetching reporter username");
        GetReporter operation = new GetReporter(this.client);
        return this.doInCatchBlock(operation);
    }

    @Override
    public CimProject findProjectForCreateById(Long projectId) {
        LOGGER.debug("fetching issue creation metadata (project id : '{}')", (Object)projectId);
        GetProjectForCreateById operation = new GetProjectForCreateById(this.client, projectId);
        return this.doInCatchBlock(operation);
    }

    @Override
    public CimProject findProjectForCreateByKey(String projectKey) {
        LOGGER.debug("fetching issue creation metadata (project key : '{}')", (Object)projectKey);
        GetProjectForCreateByKey operation = new GetProjectForCreateByKey(this.client, projectKey);
        return this.doInCatchBlock(operation);
    }

    @Override
    public Issue findIssue(String issueKey) {
        LOGGER.debug("fetching issue '{}'", (Object)issueKey);
        GetIssue operation = new GetIssue(this.client, issueKey);
        return this.doInCatchBlock(operation);
    }

    @Override
    public Iterable<Issue> findIssues(List<String> issueKeys) {
        LOGGER.debug("fetching issues : {}", issueKeys);
        GetIssues operation = new GetIssues(this.client, issueKeys);
        Object issues = new ArrayList();
        try {
            issues = operation.doIt();
        }
        catch (RestClientException ex) {
            LOGGER.trace("JIRA REST client : an error occured during operation : " + operation.toString(), (Throwable)ex);
            this.findDeletedIssues(issueKeys, (Iterable<? extends Issue>)issues);
        }
        return this.findMovedIssues((Iterable<Issue>)issues, issueKeys);
    }

    private void findDeletedIssues(List<String> issueKeys, Iterable<? extends Issue> issues) {
        LOGGER.debug("looking for deleted issues among {}", issueKeys);
        for (String issueKey : issueKeys) {
            GetIssue getIssue = new GetIssue(this.client, issueKey);
            try {
                ((ArrayList)issues).add(getIssue.doIt());
                LOGGER.trace("\tissue : {} - alive", (Object)issueKey);
            }
            catch (RestClientException restClientException) {
                LOGGER.trace("\tissue : {} - deleted", (Object)issueKey);
                ((ArrayList)issues).add(new StubIssue(issueKey, this.messageSource, this.getLocale()));
            }
        }
    }

    private List<Issue> findMovedIssues(Iterable<Issue> issues, List<String> issueKeys) {
        LOGGER.debug("looking for moved issues among {}", issueKeys);
        ArrayList<Issue> issuesWithCorrectKey = new ArrayList<Issue>();
        ArrayList<String> btIssueKeys = new ArrayList<String>();
        for (Issue issue : issues) {
            btIssueKeys.add(issue.getKey());
        }
        block1: for (String issueKey : issueKeys) {
            if (btIssueKeys.contains(issueKey)) {
                for (Issue issue : issues) {
                    if (!issue.getKey().equals(issueKey)) continue;
                    issuesWithCorrectKey.add(issue);
                    LOGGER.trace("\tissue : {} - still in place", (Object)issueKey);
                    continue block1;
                }
                continue;
            }
            LOGGER.trace("\tissue : {} - probably moved, investigating further", (Object)issueKey);
            issuesWithCorrectKey.add(this.findMovedIssue(issueKey));
        }
        return issuesWithCorrectKey;
    }

    public MovedIssue findMovedIssue(String issueKey) {
        LOGGER.debug("\tlooking for (presumably) moved issue '{}'", (Object)issueKey);
        GetIssue operation = new GetIssue(this.client, issueKey);
        return new MovedIssue(operation.doItWithChangelog(), issueKey);
    }

    @Override
    public BasicIssue createIssue(IssueInput issueInput) {
        LOGGER.debug("creating new issue");
        CreateIssue operation = new CreateIssue(this.client, issueInput);
        return this.doInCatchBlock(operation);
    }

    @Override
    public URL findIssueURL(String issueKey) {
        LOGGER.debug("finding URL for issue {}", (Object)issueKey);
        FindIssueURL operation = new FindIssueURL(this.client, issueKey);
        return this.doInCatchBlock(operation);
    }

    @Override
    public void forwardAttachments(String issueKey, Collection<AttachmentInput> attachments) {
        LOGGER.debug("forwarding attachments for issue {}", (Object)issueKey);
        ForwardAttachments operation = new ForwardAttachments(this.client, issueKey, attachments);
        this.doInCatchBlock(operation);
    }

    @Override
    public Iterable<BasicUser> searchAssignableUsers(String projectKey, String namePrefix) {
        LOGGER.debug("searching assignable users in project '{}' having names starting with '{}'", (Object)projectKey, (Object)namePrefix);
        if (!disabledExtension) {
            LOGGER.trace("\textension client enabled, proceeding");
            SearchAssignableUsers operation = new SearchAssignableUsers(this.client, projectKey, namePrefix);
            return this.doInCatchBlock(operation);
        }
        LOGGER.trace("\textension client disabled, cannot search the assignable users. Returning empty list.");
        return Collections.emptyList();
    }

    @Override
    public Iterable<BasicUser> searchPossisbleReporter(String namePrefix) {
        LOGGER.debug("searching reporters having name starting with '{}'", (Object)namePrefix);
        if (!disabledExtension) {
            LOGGER.trace("\textension client enabled, proceeding");
            SearchUsers operation = new SearchUsers(this.client, namePrefix);
            return this.doInCatchBlock(operation);
        }
        LOGGER.trace("\textension client disabled, cannot search the reporters. Returning empty list.");
        return Collections.emptyList();
    }

    @Override
    public Iterable<SimpleSprint> searchAvailableSprints() {
        AuthenticationProtocol protocol = bugtracker.getAuthenticationProtocol();
        LOGGER.debug("searching available sprints");
        if (!disabledExtension) {
            LOGGER.trace("\textension client enabled, proceeding");
            if (AuthenticationProtocol.OAUTH_2.equals((Object)protocol)) {
                SearchSprints operation = new SearchSprints(this.client, this.baseUrl);
                return this.doInCatchBlock(operation);
            }
            SearchSprintsWithGreenHopper operation = new SearchSprintsWithGreenHopper(this.client, this.greenHopperURI);
            return this.doInCatchBlock(operation);
        }
        LOGGER.trace("\textension client disabled, cannot search the sprints. Returning empty list.");
        return Collections.emptyList();
    }

    @Override
    public Iterable<BasicEntity> searchAvailableEpics(String projectKey, String searchString) {
        LOGGER.debug("searching available epics for project '{}' with name like '{}'", (Object)projectKey, (Object)searchString);
        AuthenticationProtocol protocol = bugtracker.getAuthenticationProtocol();
        if (!disabledExtension) {
            LOGGER.trace("\textension client enabled, proceeding");
            JiraRestClientOperation operation = AuthenticationProtocol.OAUTH_2.equals((Object)protocol) ? new SearchEpics(this.client, searchString) : new SearchEpicsWithGreenHopper(this.client, this.greenHopperURI, projectKey, searchString);
            return this.doInCatchBlock(operation);
        }
        LOGGER.trace("\textension client disabled, cannot search the epics. Returning empty list.");
        return Collections.emptyList();
    }

    @Override
    public void linkIssue(LinkIssuesInput input) {
        LOGGER.debug("Creation of link {} from issue {} to issue {}", new Object[]{input.getLinkType(), input.getFromIssueKey(), input.getToIssueKey()});
        LinkIssue operation = new LinkIssue(this.client, input);
        this.doInCatchBlock(operation);
    }

    @Override
    public Iterable<BasicUser> findUserByUsername(String username) {
        SearchUsers operation = new SearchUsers(this.client, username);
        return this.doInCatchBlock(operation);
    }

    @Override
    public Permissions getUserPickerPermission() {
        GetUserPickerPermission operation = new GetUserPickerPermission(this.client);
        return this.doInCatchBlock(operation);
    }

    @Override
    public BasicUser getMyself() {
        GetMyself operation = new GetMyself(this.client);
        return this.doInCatchBlock(operation);
    }

    private <ANY> ANY doInCatchBlock(JiraRestClientOperation<? extends ANY> operation) {
        try {
            return operation.doIt();
        }
        catch (JiraProjectNotFound ex) {
            LOGGER.error("JIRA REST client : project identified by " + ex.getMessage() + " was not found", (Throwable)ex);
            throw this.exceptionHandler.projectNotFound(ex);
        }
        catch (UniformInterfaceException ex) {
            LOGGER.error("JIRA REST client : an error occured during operation : " + operation.getName(), (Throwable)ex);
            throw this.exceptionHandler.handleUniformException(ex, ex.getMessage());
        }
        catch (RestClientException ex) {
            LOGGER.error("JIRA REST client : an error occured during operation : " + operation.getName(), (Throwable)ex);
            throw this.exceptionHandler.handleRestException(ex);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("JIRA REST client : an error occured during operation : " + operation.getName(), (Throwable)ex);
            throw this.exceptionHandler.genericError(ex);
        }
        catch (CannotTransformValueException ex) {
            LOGGER.error("JIRA REST client : an error occured during operation : " + operation.getName(), (Throwable)ex);
            throw this.exceptionHandler.genericError(ex);
        }
        catch (Exception ex) {
            LOGGER.error("JIRA REST client : an error occured during operation : " + operation.getName(), (Throwable)ex);
            throw this.exceptionHandler.genericError(ex);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            LOGGER.debug("closing client");
            this.client.close();
        } else {
            LOGGER.debug("client was null, nothing to close");
        }
    }

    private BugTrackerLocalException logAndThrowLocalException(String message, Exception cause) {
        LOGGER.error(message);
        return new BugTrackerLocalException(message, (Throwable)cause);
    }

    private static AuthenticationHandler createAuthHandler(Credentials credentials) {
        return switch (credentials.getImplementedProtocol()) {
            case AuthenticationProtocol.BASIC_AUTH -> {
                BasicAuthenticationCredentials basicCreds = (BasicAuthenticationCredentials)credentials;
                yield new Latin1BasicAuthHandler(basicCreds.getUsername(), new String(basicCreds.getPassword()));
            }
            case AuthenticationProtocol.OAUTH_2 -> {
                OAuth2Credentials oauth2Creds = (OAuth2Credentials)credentials;
                yield new OAuth2Handler(oauth2Creds);
            }
            default -> throw new UnsupportedAuthenticationModeException(credentials.getImplementedProtocol().toString());
        };
    }

    private static String getCloudIdForOauth2ApiRequest(OAuth2Credentials credentials) {
        HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
        String cloudId = null;
        String tokenType = StringUtils.capitalize((String)credentials.getTokenType());
        try {
            HttpRequest request = HttpRequest.newBuilder().header(HTTP_AUTHORIZATION, tokenType + " " + credentials.getAccessToken()).uri(new URI(ATLASSIAN_TOKEN_ACCESSIBLE_RESOURCES_API_ENDPOINT)).GET().build();
            HttpResponse<String> httpResponse = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            String responseBody = httpResponse.body();
            int statusCode = httpResponse.statusCode();
            if (statusCode == 200) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode jsJiraInstances = mapper.readTree(responseBody);
                cloudId = JiraCloudClientImpl.retrieveCloudIdByInstance(bugtracker, jsJiraInstances);
            }
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            LOGGER.error("Error while retrieving Oauth2 Jira Cloud ID", (Throwable)e);
        }
        return cloudId;
    }

    private static String retrieveCloudIdByInstance(BugTracker server, JsonNode jsJiraInstances) {
        int i = 0;
        while (i < jsJiraInstances.size()) {
            JsonNode obj = jsJiraInstances.get(i);
            String btUrl = server.getUrl().replaceAll("\\/*$", "");
            String jiraInstanceUrl = obj.get("url").asText();
            if (jiraInstanceUrl.equals(btUrl)) {
                return obj.get("id").asText();
            }
            ++i;
        }
        return null;
    }

    private static final class Latin1BasicAuthHandler
    implements AuthenticationHandler {
        private String username;
        private String password;

        Latin1BasicAuthHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void configure(Request.Builder builder) {
            byte[] encoded = this.encode(this.username, this.password);
            builder.setHeader(JiraCloudClientImpl.HTTP_AUTHORIZATION, "Basic " + new String(encoded));
        }

        private byte[] encode(String username, String password) {
            String toEncode = username + ":" + password;
            return Base64.encodeBase64((byte[])EncodingUtils.getBytes(toEncode, StandardCharsets.ISO_8859_1.name()));
        }
    }

    private static final class OAuth2Handler
    implements AuthenticationHandler {
        private final OAuth2Credentials credentials;

        public OAuth2Handler(OAuth2Credentials credentials) {
            this.credentials = credentials;
        }

        @Override
        public void configure(Request.Builder builder) {
            String tokenType = StringUtils.capitalize((String)this.credentials.getTokenType());
            builder.setHeader(JiraCloudClientImpl.HTTP_AUTHORIZATION, String.format("%s %s", tokenType, this.credentials.getAccessToken()));
        }
    }
}

