/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.org.apache.http.impl.client;

import java.io.IOException;
import jiracloud.org.apache.http.HttpEntity;
import jiracloud.org.apache.http.HttpResponse;
import jiracloud.org.apache.http.StatusLine;
import jiracloud.org.apache.http.annotation.Contract;
import jiracloud.org.apache.http.annotation.ThreadingBehavior;
import jiracloud.org.apache.http.client.HttpResponseException;
import jiracloud.org.apache.http.client.ResponseHandler;
import jiracloud.org.apache.http.util.EntityUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

