/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.com.atlassian.jira.rest.client.internal.json.gen;

import jiracloud.com.atlassian.jira.rest.client.api.domain.input.VersionInput;
import jiracloud.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jiracloud.com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import jiracloud.org.codehaus.jettison.json.JSONException;
import jiracloud.org.codehaus.jettison.json.JSONObject;

public class VersionInputJsonGenerator
implements JsonGenerator<VersionInput> {
    @Override
    public JSONObject generate(VersionInput version) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", version.getName());
        jsonObject.put("project", version.getProjectKey());
        if (version.getDescription() != null) {
            jsonObject.put("description", version.getDescription());
        }
        if (version.getReleaseDate() != null) {
            jsonObject.put("releaseDate", JsonParseUtil.formatDate(version.getReleaseDate()));
        }
        jsonObject.put("released", version.isReleased());
        jsonObject.put("archived", version.isArchived());
        return jsonObject;
    }
}

