/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.com.atlassian.httpclient.apache.httpcomponents.proxy;

import com.google.common.collect.Lists;
import jiracloud.com.atlassian.httpclient.apache.httpcomponents.proxy.ProvidedProxyConfig;
import jiracloud.com.atlassian.httpclient.apache.httpcomponents.proxy.ProxyConfig;
import jiracloud.com.atlassian.httpclient.apache.httpcomponents.proxy.SystemPropertiesProxyConfig;
import jiracloud.com.atlassian.httpclient.api.factory.HttpClientOptions;
import jiracloud.io.atlassian.fugue.Option;
import jiracloud.org.apache.http.HttpHost;

public class ProxyConfigFactory {
    public static Option<HttpHost> getProxyHost(HttpClientOptions options) {
        return ProxyConfigFactory.getProxyConfig(options).fold(Option::none, ProxyConfig::getProxyHost);
    }

    public static Iterable<ProxyConfig.AuthenticationInfo> getProxyAuthentication(HttpClientOptions options) {
        return ProxyConfigFactory.getProxyConfig(options).fold(Lists::newLinkedList, ProxyConfig::getAuthenticationInfo);
    }

    public static Option<ProxyConfig> getProxyConfig(HttpClientOptions options) {
        Option<ProxyConfig> config;
        switch (options.getProxyOptions().getProxyMode()) {
            case SYSTEM_PROPERTIES: {
                config = Option.some(new SystemPropertiesProxyConfig());
                break;
            }
            case CONFIGURED: {
                config = Option.some(new ProvidedProxyConfig(options.getProxyOptions().getProxyHosts(), options.getProxyOptions().getNonProxyHosts()));
                break;
            }
            default: {
                config = Option.none();
            }
        }
        return config;
    }
}

